/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.DockActionImportance;
import java.util.Iterator;

public class LineDockActionSource
extends AbstractDockActionSource {
    private DockActionSource source;
    private SeparatorAction separator = new Separator();
    private DockActionSourceListener listener = new DockActionSourceListener(){

        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            if (source.getDockActionCount() == 0) {
                LineDockActionSource.this.fireRemoved(0, lastIndex + 1);
            } else {
                LineDockActionSource.this.fireRemoved(firstIndex + 1, lastIndex + 1);
            }
        }

        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            int count = lastIndex - firstIndex + 1;
            if (count == source.getDockActionCount()) {
                LineDockActionSource.this.fireAdded(0, lastIndex + 1);
            } else {
                LineDockActionSource.this.fireAdded(firstIndex + 1, lastIndex + 1);
            }
        }
    };

    public LineDockActionSource(DockActionSource source) {
        this.source = source;
    }

    public LocationHint getLocationHint() {
        return this.source.getLocationHint();
    }

    public int getDockActionCount() {
        int count = this.source.getDockActionCount();
        if (count > 0) {
            ++count;
        }
        return count;
    }

    public DockAction getDockAction(int index) {
        if (index == 0) {
            return this.separator;
        }
        return this.source.getDockAction(index - 1);
    }

    public void addDockActionSourceListener(DockActionSourceListener listener) {
        if (!this.hasListeners()) {
            this.source.addDockActionSourceListener(this.listener);
        }
        super.addDockActionSourceListener(listener);
    }

    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (!this.hasListeners()) {
            this.source.removeDockActionSourceListener(this.listener);
        }
    }

    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private boolean separatorSent = false;
            private Iterator<DockAction> inner = LineDockActionSource.access$000(LineDockActionSource.this).iterator();

            @Override
            public DockAction next() {
                if (this.separatorSent) {
                    return this.inner.next();
                }
                this.separatorSent = true;
                return LineDockActionSource.this.separator;
            }

            @Override
            public boolean hasNext() {
                if (this.separatorSent) {
                    return this.inner.hasNext();
                }
                return LineDockActionSource.this.getDockActionCount() > 0;
            }

            @Override
            public void remove() {
                if (!this.separatorSent) {
                    throw new IllegalStateException("not supported for the first element");
                }
                this.inner.remove();
            }
        };
    }

    static /* synthetic */ DockActionSource access$000(LineDockActionSource x0) {
        return x0.source;
    }

    @DockActionImportance(value=0.0)
    private class Separator
    extends SeparatorAction {
        public Separator() {
            super(new ViewTarget[]{ViewTarget.TITLE});
        }
    }
}

