/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ToolbarDockTitleGrip
extends AbstractDockTitle {
    private Color backgroundColor = UIManager.getColor("Button.background");
    private Color gripShadowColor = Color.gray;
    private Color gripColor = Color.white;

    public static DockTitleFactory createFactory(final Color backgroundColor, final Color gripColor, final Color gripShadowColor) {
        return new DockTitleFactory(){

            public void uninstall(DockTitleRequest request) {
            }

            public void request(DockTitleRequest request) {
                request.answer((DockTitle)new ToolbarDockTitleGrip(request.getVersion(), request.getTarget(), backgroundColor, gripColor, gripShadowColor));
            }

            public void install(DockTitleRequest request) {
            }
        };
    }

    public static DockTitleFactory createFactory() {
        return new DockTitleFactory(){

            public void uninstall(DockTitleRequest request) {
            }

            public void request(DockTitleRequest request) {
                request.answer((DockTitle)new ToolbarDockTitleGrip(request.getVersion(), request.getTarget()));
            }

            public void install(DockTitleRequest request) {
            }
        };
    }

    public ToolbarDockTitleGrip(DockTitleVersion origin, Dockable dockable, Color backgroundColor, Color gripColor, Color gripShadowColor) {
        super(dockable, origin, true);
        this.backgroundColor = backgroundColor;
        this.gripColor = gripColor;
        this.gripShadowColor = gripShadowColor;
    }

    public ToolbarDockTitleGrip(DockTitleVersion origin, Dockable dockable) {
        super(dockable, origin, true);
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return (BasicTitleViewItem)dockable.getController().getActionViewConverter().createView(action, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(5, size.width), Math.max(5, size.height));
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        int lineOffset = 5;
        int headerOffset = 3;
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getOrientation().isHorizontal()) {
            int width = this.getSize().width;
            g.setColor(this.gripColor);
            g.drawLine(5, 3, width - 5, 3);
            g.drawLine(5, 4, width - 5, 4);
            g.setColor(this.gripShadowColor);
            g.drawLine(width - 5 + 1, 3, width - 5 + 1, 5);
            g.drawLine(5, 5, width - 5, 5);
        } else {
            int height = this.getSize().height;
            g.setColor(this.gripColor);
            g.drawLine(3, 5, 3, height - 5);
            g.drawLine(4, 5, 4, height - 5);
            g.setColor(this.gripShadowColor);
            g.drawLine(3, height - 5 + 1, 5, height - 5 + 1);
            g.drawLine(5, 5, 5, height - 5);
        }
    }
}

