/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.dock.station.toolbar.menu.AbstractCustomizationMenu;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DefaultCustomizationMenu
extends AbstractCustomizationMenu {
    private JDialog dialog;
    private boolean undecorated = true;
    private boolean closeOnFocusLost = true;

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setCloseOnFocusLost(boolean closeOnFocusLost) {
        this.closeOnFocusLost = closeOnFocusLost;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost;
    }

    @Override
    protected void doOpen(int x, int y, Component content) {
        this.dialog = this.createDialog(this.getCallback().getParent());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                DefaultCustomizationMenu.this.closed();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultCustomizationMenu.this.close();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomizationMenuCallback callback = DefaultCustomizationMenu.this.getCallback();
                        if (DefaultCustomizationMenu.this.isCloseOnFocusLost() && (callback == null || callback.isAutoCloseAllowed())) {
                            DefaultCustomizationMenu.this.close();
                        }
                    }
                });
            }
        });
        this.dialog.setUndecorated(this.undecorated);
        this.dialog.add(content, "Center");
        this.dialog.pack();
        this.dialog.setLocation(x, y);
        this.validateBounds();
        this.dialog.setVisible(true);
    }

    @Override
    protected void doClose() {
        this.dialog.dispose();
        this.dialog.getContentPane().removeAll();
        this.dialog = null;
    }

    private void validateBounds() {
        Rectangle bounds = this.dialog.getBounds();
        Point location = this.dialog.getLocation();
        GraphicsConfiguration bestConfiguration = null;
        int bestDistance = 0;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : environment.getScreenDevices()) {
            int dy;
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            Rectangle screenBounds = configuration.getBounds();
            if (screenBounds.contains(location)) {
                bestConfiguration = configuration;
                bestDistance = 0;
                continue;
            }
            int dx = screenBounds.x <= location.x && screenBounds.x + screenBounds.width >= location.x ? 0 : Math.min(Math.abs(screenBounds.x - location.x), Math.abs(screenBounds.x + screenBounds.width - location.x));
            int delta = dx + (dy = screenBounds.y <= location.y && screenBounds.y + screenBounds.height >= location.y ? 0 : Math.min(Math.abs(screenBounds.y - location.y), Math.abs(screenBounds.y + screenBounds.height - location.y)));
            if (delta >= bestDistance && bestConfiguration != null) continue;
            bestDistance = delta;
            bestConfiguration = configuration;
        }
        if ((bounds = this.validateBounds(bounds, bestConfiguration)) != null) {
            this.dialog.setBounds(bounds);
        }
    }

    protected Rectangle validateBounds(Rectangle bounds, GraphicsConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        Rectangle screen = configuration.getBounds();
        bounds = new Rectangle(bounds);
        bounds.width = Math.min(bounds.width, screen.width);
        bounds.height = Math.min(bounds.height, screen.height);
        bounds.x = Math.min(Math.max(bounds.x, screen.x), screen.x + screen.width - bounds.width);
        bounds.y = Math.min(Math.max(bounds.y, screen.y), screen.y + screen.height - bounds.height);
        return bounds;
    }

    protected JDialog createDialog(Component owner) {
        Window window = SwingUtilities.getWindowAncestor(owner);
        if (window instanceof Frame) {
            return new JDialog((Frame)window);
        }
        if (window instanceof Dialog) {
            return new JDialog((Dialog)window);
        }
        return new JDialog();
    }
}

