/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.toolbar.layout.GridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGridConverter;
import bibliothek.gui.dock.station.toolbar.layout.grid.Column;
import bibliothek.gui.dock.station.toolbar.layout.grid.ColumnItem;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PlaceholderToolbarGrid<D, S, P extends PlaceholderListItem<D>> {
    private GridPlaceholderList<D, S, P> columns;
    private PlaceholderStrategy strategy;
    private final PlaceholderStrategyListener strategyListener = new PlaceholderStrategyListener(){

        public void placeholderInvalidated(Set<Path> placeholders) {
            PlaceholderToolbarGrid.this.purge();
        }
    };
    private boolean bound = false;

    protected void init() {
        this.columns = this.createGrid();
    }

    protected abstract PlaceholderList<D, S, P> createColumn();

    protected abstract GridPlaceholderList<D, S, P> createGrid();

    protected abstract Set<Path> getPlaceholders(D var1);

    protected abstract void onInserted(PlaceholderList<D, S, P> var1, int var2, P var3, int var4);

    protected abstract void onRemoved(PlaceholderList<D, S, P> var1, int var2, P var3, int var4);

    protected abstract void onInserted(PlaceholderList<D, S, P> var1, int var2);

    protected abstract void onRemoved(PlaceholderList<D, S, P> var1, int var2);

    protected abstract void onInserted();

    protected abstract void onRemoved();

    public void clear() {
        this.purge();
        for (Column column : this.columns.dockables()) {
            column.getList().unbind();
            column.getList().setStrategy(null);
        }
        this.columns.clear();
        this.onRemoved();
    }

    public void insert(int column, int line, P item) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        PlaceholderList<D, S, P> list = this.getColumn(column);
        if (list == null) {
            this.insert(column, item, true);
        } else {
            int index = Math.min(line, list.dockables().size());
            list.dockables().add(index, item);
            this.ensureRemoved(list, item);
            this.onInserted(list, column, item, index);
        }
    }

    public void insert(int columnIndex, P item) {
        this.insert(columnIndex, item, true);
    }

    public void insert(int columnIndex, P item, boolean reuse) {
        PlaceholderList<D, S, P> columnList = this.createColumn();
        Column<D, S, P> column = this.columns.createColumn(columnList);
        boolean added = false;
        int addedColumnIndex = -1;
        if (reuse) {
            PlaceholderList.Item columnItem;
            int baseIndex;
            if (this.columns.dockables().size() > 0) {
                baseIndex = this.columns.levelToBase(Math.max(0, Math.min(this.columns.dockables().size() - 1, columnIndex)), PlaceholderList.Level.DOCKABLE);
                --baseIndex;
            } else {
                baseIndex = 0;
            }
            if (baseIndex >= 0 && baseIndex < this.columns.list().size() && (columnItem = (PlaceholderList.Item)this.columns.list().get(baseIndex)).getDockable() == null) {
                PlaceholderMap map = columnItem.getPlaceholderMap();
                if (map != null) {
                    columnList.read(map, this.columns.getConverter());
                }
                columnItem.setDockable(column);
                addedColumnIndex = this.columns.dockables().indexOf(column);
                this.onInserted(column.getList(), addedColumnIndex);
                added = true;
            }
        }
        columnList.dockables().add(item);
        if (added) {
            this.onInserted(columnList, addedColumnIndex, item, columnList.dockables().size() - 1);
        } else {
            int index = Math.max(0, Math.min(columnIndex, this.columns.dockables().size()));
            this.columns.dockables().add(index, column);
            this.onInserted(columnList, index);
            this.onInserted(columnList, index, item, columnList.dockables().size() - 1);
        }
        if (this.bound) {
            columnList.setStrategy(this.strategy);
        }
        this.ensureRemoved(columnList, item);
    }

    public void move(int sourceColumn, int sourceLine, int destinationColumn, int destinationLine, PlaceholderList.Level destinationLevel) {
        PlaceholderList.Item item;
        PlaceholderList<D, S, P> list;
        PlaceholderList source = ((Column)this.columns.dockables().get(sourceColumn)).getList();
        PlaceholderList.Filter sourceList = source.dockables();
        int destinationColumnIndex = -1;
        if (destinationColumn == this.columns.size(destinationLevel)) {
            destinationColumn = this.columns.size(PlaceholderList.Level.BASE);
        } else if (destinationColumn >= 0) {
            destinationColumn = this.columns.levelToBase(destinationColumn, destinationLevel);
        }
        if (sourceLine < 0 || sourceLine >= sourceList.size()) {
            throw new IllegalArgumentException("sourceLine out of bounds: " + sourceLine);
        }
        if (destinationColumn < -1 || destinationColumn > this.columns.list().size()) {
            throw new IllegalArgumentException("destinationColumn out of bounds: " + destinationColumn);
        }
        PlaceholderListItem value = (PlaceholderListItem)sourceList.get(sourceLine);
        if (destinationColumn == -1 || destinationColumn == this.columns.list().size()) {
            list = this.createColumn();
            if (destinationLine != 0) {
                throw new IllegalArgumentException("destinationLine is out of bounds: " + destinationLine);
            }
            GridPlaceholderList<D, S, P> gridPlaceholderList = this.columns;
            ((Object)gridPlaceholderList).getClass();
            item = new PlaceholderList.Item(gridPlaceholderList, this.columns.createColumn(list));
            if (destinationColumn == -1) {
                this.columns.list().add(0, (Object)item);
            } else {
                this.columns.list().add((Object)item);
            }
            destinationColumnIndex = this.columns.dockables().indexOf((Object)item.getDockable());
            this.onInserted(list, destinationColumnIndex);
        } else {
            item = (PlaceholderList.Item)this.columns.list().get(destinationColumn);
            if (item.getDockable() == null) {
                list = this.createColumn();
                if (destinationLine != 0) {
                    throw new IllegalArgumentException("destinationLine is out of bounds: " + destinationLine);
                }
                item.setDockable(this.columns.createColumn(list));
                destinationColumnIndex = this.columns.dockables().indexOf((Object)item.getDockable());
                this.onInserted(list, destinationColumnIndex);
            } else {
                list = ((Column)item.getDockable()).getList();
                if (destinationLine < 0 || destinationLine > list.dockables().size()) {
                    throw new IllegalArgumentException("destinationLine out of bounds: " + destinationLine);
                }
                destinationColumnIndex = this.columns.baseToLevel(destinationColumn, PlaceholderList.Level.DOCKABLE);
            }
        }
        PlaceholderListItem moved = (PlaceholderListItem)sourceList.get(sourceLine);
        list.dockables().move(sourceList, sourceLine, destinationLine);
        this.ensureRemoved(list, value);
        this.onRemoved(source, sourceColumn, moved, sourceLine);
        this.onInserted(list, destinationColumnIndex, moved, destinationLine);
        this.purge();
    }

    public boolean put(Path placeholder, P item) {
        PlaceholderMap map;
        int listIndex = this.columns.getListIndex(placeholder);
        if (listIndex == -1) {
            return false;
        }
        PlaceholderList.Item listItem = (PlaceholderList.Item)this.columns.list().get(listIndex);
        Column<D, S, P> column = (Column<D, S, P>)listItem.getDockable();
        if (column != null) {
            int columnIndex = this.columns.dockables().indexOf((Object)column);
            int replacingListIndex = column.getList().getListIndex(placeholder);
            if (replacingListIndex >= 0) {
                PlaceholderListItem removed = ((PlaceholderList.Item)column.getList().list().get(replacingListIndex)).getDockable();
                int size = column.getList().dockables().size();
                int removedIndex = column.getList().put(placeholder, item);
                if (removed != null) {
                    this.onRemoved(column.getList(), columnIndex, removed, removedIndex);
                    if (size == 0 && item == null) {
                        this.onRemoved(column.getList(), columnIndex);
                        listItem.setDockable(null);
                    }
                }
                if (item != null) {
                    if (size == 0) {
                        this.onInserted(column.getList(), columnIndex);
                    }
                    this.onInserted(column.getList(), columnIndex, item, column.getList().dockables().indexOf(item));
                }
                return true;
            }
        }
        if ((map = listItem.getPlaceholderMap()) != null) {
            PlaceholderList<D, S, P> list = this.createColumn();
            list.read(map, this.columns.getConverter());
            column = this.columns.createColumn(list);
            listItem.setDockable(column);
            int columnIndex = this.columns.dockables().indexOf(column);
            this.onInserted(list, columnIndex);
            int insertIndex = column.getList().put(placeholder, item);
            if (insertIndex == -1) {
                listItem.setDockable(null);
                this.onRemoved(list, columnIndex);
                return false;
            }
            listItem.setPlaceholderMap(null);
            this.ensureRemoved(list, placeholder);
            this.onInserted(list, columnIndex, item, insertIndex);
            return true;
        }
        return false;
    }

    public void addPlaceholder(int column, int line, Path placeholder) {
        this.columns.dockables().addPlaceholder(column, placeholder);
        Column item = (Column)this.columns.dockables().get(column);
        item.getList().dockables().addPlaceholder(line, placeholder);
        this.ensureRemoved(item.getList(), placeholder);
    }

    public void insertPlaceholder(int column, int line, Path placeholder) {
        PlaceholderList.Filter lineList;
        if (column == this.columns.list().size()) {
            this.columns.list().insertPlaceholder(column, placeholder);
        } else {
            this.columns.list().addPlaceholder(column, placeholder);
        }
        PlaceholderList.Item item = (PlaceholderList.Item)this.columns.list().get(column);
        if (item.getDockable() == null) {
            item.setDockable(this.columns.createColumn(this.createColumn()));
        }
        if (line == (lineList = ((Column)item.getDockable()).getList().list()).size()) {
            lineList.insertPlaceholder(line, placeholder);
        } else {
            lineList.addPlaceholder(line, placeholder);
        }
    }

    public boolean remove(P item) {
        boolean result = false;
        int columnIndex = -1;
        for (Column column : this.columns.dockables()) {
            ++columnIndex;
            int index = column.getList().dockables().indexOf(item);
            if (index < 0) continue;
            column.getList().remove(item);
            this.onRemoved(column.getList(), columnIndex, item, index);
            result = true;
        }
        this.purge();
        return result;
    }

    public void removePlaceholder(Path placeholder) {
        HashSet<Path> set = new HashSet<Path>();
        set.add(placeholder);
        this.ensureRemoved((PlaceholderList<D, S, P>)null, (Set<Path>)set);
    }

    private void ensureRemoved(PlaceholderList<D, S, P> ignore, P item) {
        Set<Path> placeholders = this.getPlaceholders(item.asDockable());
        this.ensureRemoved(ignore, placeholders);
    }

    private void ensureRemoved(PlaceholderList<D, S, P> ignore, Path placeholder) {
        HashSet<Path> set = new HashSet<Path>();
        set.add(placeholder);
        this.ensureRemoved(ignore, (Set<Path>)set);
    }

    private void ensureRemoved(PlaceholderList<D, S, P> ignore, Set<Path> placeholders) {
        Iterator iter = this.columns.list().iterator();
        while (iter.hasNext()) {
            PlaceholderList.Item item = (PlaceholderList.Item)iter.next();
            if (item.getDockable() != null && ((Column)item.getDockable()).getList() == ignore) continue;
            item.removeAll(placeholders);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iter.remove();
        }
        for (Column column : this.columns.dockables()) {
            if (column.getList() == ignore) continue;
            column.getList().removeAll(placeholders);
        }
        this.purge();
    }

    public int getColumn(D dockable) {
        int index = 0;
        Iterator<PlaceholderList<D, S, P>> columns = this.columns();
        while (columns.hasNext()) {
            for (PlaceholderListItem item : columns.next().dockables()) {
                if (item.asDockable() != dockable) continue;
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getColumn(Path placeholder) {
        int index = 0;
        for (PlaceholderList.Item item : this.columns.list()) {
            if (item.hasPlaceholder(placeholder)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getLine(D dockable) {
        int column = this.getColumn(dockable);
        if (column == -1) {
            return -1;
        }
        return this.getLine(column, dockable);
    }

    public int getLine(int column, D dockable) {
        PlaceholderList<D, S, P> list = this.getColumn(column);
        int index = 0;
        for (PlaceholderListItem item : list.dockables()) {
            if (item.asDockable() == dockable) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getLine(Path placeholder) {
        int column = this.getColumn(placeholder);
        if (column == -1) {
            return -1;
        }
        return this.getLine(column, placeholder);
    }

    public int getLine(int column, Path placeholder) {
        PlaceholderList.Item item = (PlaceholderList.Item)this.columns.list().get(column);
        if (item.getDockable() == null) {
            if (item.hasPlaceholder(placeholder)) {
                return 0;
            }
            return -1;
        }
        return ((Column)item.getDockable()).getList().list().indexOfPlaceholder(placeholder);
    }

    public boolean hasPlaceholder(Path placeholder) {
        int listIndex = this.columns.getListIndex(placeholder);
        if (listIndex == -1) {
            return false;
        }
        PlaceholderList.Item item = (PlaceholderList.Item)this.columns.list().get(listIndex);
        Column column = (Column)item.getDockable();
        if (column != null) {
            return column.getList().hasPlaceholder(placeholder);
        }
        PlaceholderMap map = item.getPlaceholderMap();
        if (map != null) {
            for (PlaceholderMap.Key key : map.getPlaceholders()) {
                if (!key.contains(placeholder)) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        int sum = 0;
        Iterator<PlaceholderList<D, S, P>> iter = this.columns();
        while (iter.hasNext()) {
            sum += iter.next().dockables().size();
        }
        return sum;
    }

    public P get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must not be < 0");
        }
        Iterator<PlaceholderList<D, S, P>> iter = this.columns();
        while (iter.hasNext()) {
            PlaceholderList.Filter dockables = iter.next().dockables();
            int size = dockables.size();
            if (index < size) {
                return (P)((PlaceholderListItem)dockables.get(index));
            }
            index -= size;
        }
        throw new IllegalArgumentException("index must not be >= size");
    }

    public P get(D dockable) {
        Iterator<P> iter = this.items();
        while (iter.hasNext()) {
            PlaceholderListItem next = (PlaceholderListItem)iter.next();
            if (next.asDockable() != dockable) continue;
            return (P)next;
        }
        return null;
    }

    public P get(Path placeholder) {
        int listIndex = this.columns.getListIndex(placeholder);
        if (listIndex == -1) {
            return null;
        }
        PlaceholderList.Item item = (PlaceholderList.Item)this.columns.list().get(listIndex);
        Column column = (Column)item.getDockable();
        if (column == null) {
            return null;
        }
        return (P)column.getList().getDockableAt(placeholder);
    }

    protected Iterator<PlaceholderList<D, S, P>> allColumns() {
        return new Iterator<PlaceholderList<D, S, P>>(){
            private final Iterator<Column<D, S, P>> items;
            private PlaceholderList<D, S, P> current;
            private int currentIndex;
            {
                this.items = PlaceholderToolbarGrid.this.columns.dockables().iterator();
                this.currentIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.items.hasNext();
            }

            @Override
            public PlaceholderList<D, S, P> next() {
                this.current = this.items.next().getList();
                ++this.currentIndex;
                return this.current;
            }

            @Override
            public void remove() {
                this.items.remove();
                PlaceholderToolbarGrid.this.onRemoved(this.current, this.currentIndex--);
            }
        };
    }

    protected Iterator<PlaceholderList<D, S, P>> columns() {
        return new Iterator<PlaceholderList<D, S, P>>(){
            private final Iterator<Column<D, S, P>> items;
            private PlaceholderList<D, S, P> next;
            {
                this.items = PlaceholderToolbarGrid.this.columns.dockables().iterator();
            }

            private void forward() {
                this.next = null;
                while (this.next == null && this.items.hasNext()) {
                    PlaceholderList column = this.items.next().getList();
                    if (column.dockables().size() <= 0) continue;
                    this.next = column;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null && this.items.hasNext()) {
                    this.forward();
                }
                return this.next != null;
            }

            @Override
            public PlaceholderList<D, S, P> next() {
                PlaceholderList result = this.next;
                this.forward();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<P> items() {
        return new Iterator<P>(){
            private final Iterator<PlaceholderList<D, S, P>> columns;
            private Iterator<P> items;
            private PlaceholderList<D, S, P> currentList;
            private int currentListIndex;
            private P currentItem;
            private int currentItemIndex;
            private boolean requiresdPurge;
            {
                this.columns = PlaceholderToolbarGrid.this.columns();
                this.items = null;
                this.currentListIndex = -1;
                this.currentItemIndex = -1;
                this.requiresdPurge = false;
            }

            private void validate() {
                while ((this.items == null || !this.items.hasNext()) && this.columns.hasNext()) {
                    this.currentList = this.columns.next();
                    this.currentItemIndex = -1;
                    ++this.currentListIndex;
                    this.items = this.currentList.dockables().iterator();
                }
            }

            @Override
            public boolean hasNext() {
                boolean result;
                this.validate();
                boolean bl = result = this.items != null && this.items.hasNext();
                if (!result && this.requiresdPurge) {
                    PlaceholderToolbarGrid.this.purge();
                    this.requiresdPurge = false;
                }
                return result;
            }

            @Override
            public P next() {
                this.validate();
                this.currentItem = (PlaceholderListItem)this.items.next();
                return this.currentItem;
            }

            @Override
            public void remove() {
                if (this.items == null) {
                    throw new IllegalStateException("no item selected");
                }
                this.items.remove();
                PlaceholderToolbarGrid.this.onRemoved(this.currentList, this.currentListIndex, this.currentItem, this.currentItemIndex--);
                this.requiresdPurge = true;
            }
        };
    }

    public int getColumnCount() {
        return this.columns.dockables().size();
    }

    public int getLineCount(int column) {
        return ((Column)this.columns.dockables().get(column)).getList().dockables().size();
    }

    public int getTotalColumnCount() {
        return this.columns.list().size();
    }

    public Iterator<P> getColumnContent(final int index) {
        final PlaceholderList<D, S, P> list = this.getColumn(index);
        if (list == null) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        return new Iterator<P>(){
            private Iterator<P> delegate;
            private P current;
            private int currentIndex;
            private boolean requiresPurge;
            {
                this.delegate = list.dockables().iterator();
                this.currentIndex = -1;
                this.requiresPurge = false;
            }

            @Override
            public boolean hasNext() {
                boolean result = this.delegate.hasNext();
                if (!result && this.requiresPurge) {
                    PlaceholderToolbarGrid.this.purge();
                    this.requiresPurge = false;
                }
                return result;
            }

            @Override
            public P next() {
                this.current = (PlaceholderListItem)this.delegate.next();
                ++this.currentIndex;
                return this.current;
            }

            @Override
            public void remove() {
                this.delegate.remove();
                PlaceholderToolbarGrid.this.onRemoved(list, index, this.current, this.currentIndex--);
            }
        };
    }

    protected PlaceholderList<D, S, P> getColumn(int index) {
        if (index < 0) {
            return null;
        }
        PlaceholderList.Filter dockables = this.columns.dockables();
        if (index >= dockables.size()) {
            return null;
        }
        return ((Column)dockables.get(index)).getList();
    }

    public void bind() {
        this.columns.bind();
        Iterator<PlaceholderList<D, S, P>> columns = this.allColumns();
        while (columns.hasNext()) {
            columns.next().bind();
        }
        if (!this.bound) {
            this.bound = true;
            if (this.strategy != null) {
                this.strategy.addListener(this.strategyListener);
                this.purge();
            }
        }
    }

    public void unbind() {
        this.columns.unbind();
        Iterator<PlaceholderList<D, S, P>> columns = this.allColumns();
        while (columns.hasNext()) {
            columns.next().unbind();
        }
        if (this.bound) {
            this.bound = false;
            if (this.strategy != null) {
                this.strategy.removeListener(this.strategyListener);
            }
        }
    }

    public void setStrategy(PlaceholderStrategy strategy) {
        if (this.strategy != null && this.bound) {
            this.strategy.removeListener(this.strategyListener);
        }
        this.strategy = strategy;
        this.columns.setStrategy(strategy);
        Iterator<PlaceholderList<D, S, P>> columns = this.allColumns();
        while (columns.hasNext()) {
            columns.next().setStrategy(strategy);
        }
        if (this.strategy != null && this.bound) {
            this.strategy.addListener(this.strategyListener);
            this.purge();
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    private void purge() {
        this.purge(false);
    }

    private void purge(boolean silent) {
        int index = -1;
        for (PlaceholderList.Item item : this.columns.list()) {
            Column column = (Column)item.getDockable();
            if (column == null) continue;
            ++index;
            PlaceholderList list = column.getList();
            if (list.dockables().size() != 0) continue;
            item.setPlaceholderMap(list.toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<D, PlaceholderListItem<D>>(){

                public ConvertedPlaceholderListItem convert(int index, PlaceholderListItem<D> dockable) {
                    throw new IllegalStateException("the list is supposed to have no children, so this conversion method must never be called");
                }
            }));
            item.setDockable(null);
            if (silent) continue;
            this.onRemoved(list, index--);
        }
    }

    protected abstract void fill(D var1, ConvertedPlaceholderListItem var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaceholderMap toMap(final Map<D, Integer> identifiers) {
        this.columns.setConverter((PlaceholderListItemConverter<D, P>)new PlaceholderListItemAdapter<D, P>(){

            public ConvertedPlaceholderListItem convert(int index, P dockable) {
                Integer id = (Integer)identifiers.get(dockable.asDockable());
                if (id == null) {
                    return null;
                }
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("index", index);
                item.putInt("id", id.intValue());
                PlaceholderToolbarGrid.this.fill(dockable.asDockable(), item);
                return item;
            }
        });
        try {
            PlaceholderMap placeholderMap = this.columns.toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

                public ConvertedPlaceholderListItem convert(int index, Column<D, S, P> dockable) {
                    ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                    item.putInt("index", index);
                    item.setPlaceholderMap(dockable.getPlaceholders());
                    return item;
                }
            });
            return placeholderMap;
        }
        finally {
            this.columns.setConverter(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromMap(PlaceholderMap map, final Map<Integer, D> identifiers, final PlaceholderToolbarGridConverter<D, P> converter) {
        this.clear();
        this.columns.setConverter((PlaceholderListItemConverter<D, P>)new PlaceholderListItemAdapter<D, P>(){

            public P convert(ConvertedPlaceholderListItem item) {
                Integer id = item.getInt("id");
                Object dockable = identifiers.get(id);
                if (dockable == null) {
                    return null;
                }
                return converter.convert(dockable, item);
            }
        });
        try {
            this.columns.read(map, (PlaceholderListItemConverter)new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

                public Column<D, S, P> convert(ConvertedPlaceholderListItem item) {
                    PlaceholderList list = PlaceholderToolbarGrid.this.createColumn();
                    PlaceholderMap map = item.getPlaceholderMap();
                    if (map == null) {
                        return null;
                    }
                    list.read(map, PlaceholderToolbarGrid.this.columns.getConverter());
                    return PlaceholderToolbarGrid.this.columns.createColumn(list);
                }

                public void added(Column<D, S, P> dockable) {
                    for (PlaceholderListItem item : dockable.getList().dockables()) {
                        converter.added(item);
                    }
                }
            });
            this.purge(true);
        }
        finally {
            this.columns.setConverter(null);
            this.onInserted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaceholderMap toMap() {
        this.columns.setConverter((PlaceholderListItemConverter<D, P>)new PlaceholderListItemAdapter<D, P>(){

            public ConvertedPlaceholderListItem convert(int index, P dockable) {
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                PlaceholderToolbarGrid.this.fill(dockable.asDockable(), item);
                if (item.getPlaceholder() == null && item.getPlaceholderMap() == null) {
                    return null;
                }
                return item;
            }
        });
        try {
            PlaceholderMap placeholderMap = this.columns.toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

                public ConvertedPlaceholderListItem convert(int index, Column<D, S, P> dockable) {
                    ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                    item.putInt("index", index);
                    item.setPlaceholderMap(dockable.getPlaceholders());
                    return item;
                }
            });
            return placeholderMap;
        }
        finally {
            this.columns.setConverter(null);
        }
    }

    public void fromMap(PlaceholderMap map) {
        this.clear();
        this.columns.read(map, (PlaceholderListItemConverter)new PlaceholderListItemAdapter<ColumnItem<D, S, P>, Column<D, S, P>>(){

            public Column<D, S, P> convert(ConvertedPlaceholderListItem item) {
                PlaceholderMap map = item.getPlaceholderMap();
                if (map == null) {
                    return null;
                }
                PlaceholderList content = PlaceholderToolbarGrid.this.createColumn();
                content.read(map, PlaceholderToolbarGrid.this.columns.getConverter());
                return PlaceholderToolbarGrid.this.columns.createColumn(content);
            }
        });
        this.purge(true);
    }
}

