/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnListener;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModelListener;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGrid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ModeledPlaceholderToolbarGrid<D, S, P extends PlaceholderListItem<D>>
extends PlaceholderToolbarGrid<D, S, P> {
    private Model model = new Model();

    public ToolbarColumnModel<D, P> getModel() {
        return this.model;
    }

    @Override
    protected void onInserted(PlaceholderList<D, S, P> column, int columnIndex, P item, int itemIndex) {
        this.model.getColumn(columnIndex).onInserted(item, itemIndex);
    }

    @Override
    protected void onRemoved(PlaceholderList<D, S, P> column, int columnIndex, P item, int itemIndex) {
        this.model.getColumn(columnIndex).onRemoved(item, itemIndex);
    }

    @Override
    protected void onInserted(PlaceholderList<D, S, P> column, int index) {
        this.model.onInserted(index);
    }

    @Override
    protected void onRemoved(PlaceholderList<D, S, P> column, int index) {
        for (int i = column.dockables().size() - 1; i >= 0; --i) {
            this.model.getColumn(index).onRemoved((PlaceholderListItem)column.dockables().get(i), i);
        }
        this.model.onRemoved(index);
    }

    @Override
    protected void onInserted() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.model.onInserted(i);
            int index = 0;
            Iterator content = this.getColumnContent(i);
            while (content.hasNext()) {
                this.model.getColumn(i).onInserted((PlaceholderListItem)content.next(), index++);
            }
        }
    }

    @Override
    protected void onRemoved() {
        for (int i = this.model.getColumnCount() - 1; i >= 0; ++i) {
            Column column = this.model.getColumn(i);
            for (int j = column.getDockableCount() - 1; j >= 0; --j) {
                this.model.getColumn(i).onRemoved(column.getItem(j), j);
            }
            this.model.onRemoved(i);
        }
    }

    private class Column
    implements ToolbarColumn<D, P> {
        private List<P> items = new ArrayList();
        private List<ToolbarColumnListener<D, P>> listeners = new ArrayList();

        private Column() {
        }

        public void onInserted(P item, int index) {
            this.items.add(index, item);
            for (ToolbarColumnListener toolbarColumnListener : this.listeners()) {
                toolbarColumnListener.inserted(this, item, item.asDockable(), index);
            }
        }

        public void onRemoved(P item, int index) {
            this.items.remove(index);
            for (ToolbarColumnListener toolbarColumnListener : this.listeners()) {
                toolbarColumnListener.removed(this, item, item.asDockable(), index);
            }
        }

        public boolean contains(D dockable) {
            for (PlaceholderListItem item : this.items) {
                if (item.asDockable() != dockable) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getColumnIndex() {
            return ModeledPlaceholderToolbarGrid.this.model.columns.indexOf(this);
        }

        @Override
        public int getDockableCount() {
            return this.items.size();
        }

        @Override
        public D getDockable(int index) {
            return ((PlaceholderListItem)this.items.get(index)).asDockable();
        }

        @Override
        public int indexOf(Dockable dockable) {
            int n = this.getDockableCount();
            for (int i = 0; i < n; ++i) {
                if (this.getDockable(i) != dockable) continue;
                return i;
            }
            return -1;
        }

        @Override
        public P getItem(int index) {
            return (PlaceholderListItem)this.items.get(index);
        }

        private ToolbarColumnListener<D, P>[] listeners() {
            return this.listeners.toArray(new ToolbarColumnListener[this.listeners.size()]);
        }

        @Override
        public void addListener(ToolbarColumnListener<D, P> listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(ToolbarColumnListener<D, P> listener) {
            this.listeners.remove(listener);
        }
    }

    private class Model
    implements ToolbarColumnModel<D, P> {
        private List<ToolbarColumnModelListener<D, P>> modelListeners = new ArrayList();
        private List<Column> columns = new ArrayList<Column>();

        private Model() {
        }

        @Override
        public void addListener(ToolbarColumnModelListener<D, P> listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.modelListeners.add(listener);
        }

        @Override
        public void removeListener(ToolbarColumnModelListener<D, P> listener) {
            this.modelListeners.remove(listener);
        }

        protected ToolbarColumnModelListener<D, P>[] listeners() {
            return this.modelListeners.toArray(new ToolbarColumnModelListener[this.modelListeners.size()]);
        }

        public Column getColumn(int index) {
            return this.columns.get(index);
        }

        public Column getColumn(D dockable) {
            for (Column column : this.columns) {
                if (!column.contains(dockable)) continue;
                return column;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        public void onInserted(int index) {
            Column column = new Column();
            this.columns.add(index, column);
            for (ToolbarColumnModelListener listener : this.listeners()) {
                listener.inserted(this, column, index);
            }
        }

        public void onRemoved(int index) {
            Column column = this.columns.remove(index);
            for (ToolbarColumnModelListener listener : this.listeners()) {
                listener.removed(this, column, index);
            }
        }
    }
}

