/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layer;

import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarGroupInnerLayer;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class ToolbarGroupOuterLayer
extends ToolbarGroupInnerLayer {
    public ToolbarGroupOuterLayer(ToolbarGroupDockStation station, Component component) {
        super(station, component);
        this.setPriority(LayerPriority.OVERRIDE_PRECISE);
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer child) {
        return child;
    }

    @Override
    public boolean contains(int x, int y) {
        Rectangle bound;
        int i;
        ToolbarGroupDockStation station = this.getStation();
        if (!station.isAllowSideSnap()) {
            return false;
        }
        if (this.isComponentContain(x, y)) {
            return false;
        }
        int size = station.getBorderSideSnapSize();
        if (station.columnCount() == 0) {
            Point mouseCoord = new Point(x, y);
            SwingUtilities.convertPointFromScreen(mouseCoord, this.getComponent());
            Rectangle rec = this.getComponent().getBounds();
            Rectangle recSnap = new Rectangle(rec.x - size, rec.y - size, rec.width + size * 2, rec.height + size * 2);
            return recSnap.contains(mouseCoord);
        }
        Point mouseCoord = new Point(x, y);
        SwingUtilities.convertPointFromScreen(mouseCoord, this.getComponent());
        ToolbarGridLayoutManager<StationChildHandle> layout = station.getLayoutManager();
        int count = station.columnCount();
        for (i = 0; i < count; ++i) {
            bound = layout.getBounds(i);
            if (!this.isNear(bound, size, mouseCoord)) continue;
            return true;
        }
        for (i = 0; i <= count; ++i) {
            bound = layout.getGapBounds(i, true);
            if (!this.isNear(bound, size, mouseCoord)) continue;
            return true;
        }
        return false;
    }

    private boolean isNear(Rectangle boundaries, int size, Point location) {
        if (boundaries.contains(location)) {
            return false;
        }
        int dx = Math.min(Math.abs(boundaries.x - location.x), Math.abs(location.x - boundaries.x - boundaries.width));
        int dy = Math.min(Math.abs(boundaries.y - location.y), Math.abs(location.y - boundaries.y - boundaries.height));
        if (dx <= size) {
            return dy <= size || boundaries.y <= location.y && boundaries.y + boundaries.height >= location.y;
        }
        if (dy <= size) {
            return dx <= size || boundaries.x <= location.x && boundaries.x + boundaries.width >= location.x;
        }
        return false;
    }

    private boolean isComponentContain(int x, int y) {
        return super.contains(x, y);
    }
}

