/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ToolbarGroupProperty
extends AbstractDockableProperty {
    private int column;
    private int line;
    private Path placeholder;

    public ToolbarGroupProperty() {
    }

    public ToolbarGroupProperty(int column, int line, Path placeholder) {
        this.column = column;
        this.line = line;
        this.placeholder = placeholder;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[column=" + this.getColumn() + ", line=" + this.getLine() + ", placeholder=" + this.getPlaceholder() + ", successor=" + this.getSuccessor() + "]";
    }

    public DockableProperty copy() {
        ToolbarGroupProperty result = new ToolbarGroupProperty(this.column, this.line, this.placeholder);
        this.copy(result);
        return result;
    }

    public String getFactoryID() {
        return "ToolbarGroupProperty";
    }

    public void store(DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_1_1a);
        out.writeInt(this.column);
        out.writeInt(this.line);
        if (this.placeholder == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.placeholder.toString());
        }
    }

    public void store(XElement element) {
        element.addElement("column").setInt(this.column);
        element.addElement("line").setInt(this.line);
        if (this.placeholder != null) {
            element.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    public void load(DataInputStream in) throws IOException {
        Version version = Version.read((DataInputStream)in);
        if (!version.equals((Object)Version.VERSION_1_1_1a)) {
            throw new IOException("data from an unknown version: " + version);
        }
        this.column = in.readInt();
        this.line = in.readInt();
        this.placeholder = in.readBoolean() ? new Path(in.readUTF()) : null;
    }

    public void load(XElement element) {
        XElement xcolumn = element.getElement("column");
        XElement xline = element.getElement("xline");
        XElement xplaceholder = element.getElement("placeholder");
        if (xcolumn != null) {
            this.column = xcolumn.getInt();
        }
        if (xline != null) {
            this.line = xline.getInt();
        }
        this.placeholder = xplaceholder != null ? new Path(xplaceholder.getString()) : null;
    }
}

