/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverterCallback;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockPerspective;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

public class DefaultToolbarContainerConverter
implements ToolbarContainerConverter {
    @Override
    public PlaceholderMap getPlaceholders(ToolbarContainerDockStation station) {
        PlaceholderMap result = new PlaceholderMap(new Path("dock.ToolbarContainerStation"), 0);
        result.put(result.newKey("content", new Path[0]), "list", (Object)station.getDockables().toMap());
        return result;
    }

    @Override
    public PlaceholderMap getPlaceholders(ToolbarContainerDockStation station, Map<Dockable, Integer> children) {
        PlaceholderMap result = new PlaceholderMap(new Path("dock.ToolbarContainerStation"), 0);
        result.put(result.newKey("content", new Path[0]), "list", (Object)this.convert(station.getPlaceholderStrategy(), station.getDockables(), children));
        return result;
    }

    @Override
    public PlaceholderMap getPlaceholders(ToolbarContainerDockPerspective station, Map<PerspectiveDockable, Integer> children) {
        PlaceholderMap result = new PlaceholderMap(new Path("dock.ToolbarContainerStation"), 0);
        result.put(result.newKey("content", new Path[0]), "list", (Object)this.convert(station.getDockables(), children));
        return result;
    }

    private PlaceholderMap convert(final PlaceholderStrategy strategy, DockablePlaceholderList<StationChildHandle> list, final Map<Dockable, Integer> children) {
        return list.toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){

            public ConvertedPlaceholderListItem convert(int index, StationChildHandle handle) {
                Path placeholder;
                Dockable dockable = handle.getDockable();
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                Integer id = (Integer)children.get(dockable);
                if (id == null) {
                    return null;
                }
                item.putInt("id", id.intValue());
                item.putInt("index", index);
                if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable)) != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    private PlaceholderMap convert(PerspectivePlaceholderList<PerspectiveDockable> list, final Map<PerspectiveDockable, Integer> children) {
        return list.toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            public ConvertedPlaceholderListItem convert(int index, PerspectiveDockable dockable) {
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                Integer id = (Integer)children.get(dockable);
                if (id == null) {
                    return null;
                }
                item.putInt("id", id.intValue());
                item.putInt("index", index);
                Path placeholder = dockable.getPlaceholder();
                if (placeholder != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    @Override
    public void setPlaceholders(ToolbarContainerDockStation station, PlaceholderMap map) {
        if (!map.getFormat().equals((Object)new Path("dock.ToolbarContainerStation"))) {
            throw new IllegalArgumentException("unknown format: " + map.getFormat());
        }
        if (map.getVersion() != 0) {
            throw new IllegalArgumentException("unknown version: " + map.getVersion());
        }
        station.setPlaceholders(map.getMap(map.newKey("content", new Path[0]), "list"));
    }

    @Override
    public void setPlaceholders(ToolbarContainerDockStation station, ToolbarContainerConverterCallback callback, PlaceholderMap map, Map<Integer, Dockable> children) {
        this.convert(station, callback, map.getMap(map.newKey("content", new Path[0]), "list"), children);
    }

    private void convert(final ToolbarContainerDockStation station, final ToolbarContainerConverterCallback callback, PlaceholderMap map, final Map<Integer, Dockable> children) {
        DockablePlaceholderList list = new DockablePlaceholderList();
        callback.setDockables((DockablePlaceholderList<StationChildHandle>)list);
        list.read(map, (PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){
            private DockHierarchyLock.Token token;

            public StationChildHandle convert(ConvertedPlaceholderListItem item) {
                int id = item.getInt("id");
                Dockable dockable = (Dockable)children.get(id);
                if (dockable == null) {
                    return null;
                }
                DockUtilities.ensureTreeValidity((DockStation)station, (Dockable)dockable);
                this.token = DockHierarchyLock.acquireLinking((DockStation)station, (Dockable)dockable);
                StationChildHandle handle = callback.wrap(dockable);
                callback.adding(handle);
                return handle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void added(StationChildHandle handle) {
                try {
                    callback.added(handle);
                }
                finally {
                    this.token.release();
                }
            }
        });
        callback.finished((DockablePlaceholderList<StationChildHandle>)list);
    }
}

