/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;

public abstract class ToolbarGroupSpanStrategy<P extends PlaceholderListItem<Dockable>> {
    private DockablePlaceholderToolbarGrid<P> grid;
    private Span[] columnSpans = new Span[0];
    private Span[][] lineSpans = new Span[0][];
    private StationSpanFactoryValue factory;
    private ToolbarGroupDockStation station;
    private ToolbarGroupDividerStrategy dividers = ToolbarGroupDividerStrategy.NULL;
    private int currentColumn = -1;
    private int currentLine = -1;

    public ToolbarGroupSpanStrategy(DockablePlaceholderToolbarGrid<P> grid, ToolbarGroupDockStation station) {
        this.grid = grid;
        this.station = station;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.toolbar.group", station){

            protected void changed() {
                ToolbarGroupSpanStrategy.this.reset(true);
            }
        };
    }

    public void setDividers(ToolbarGroupDividerStrategy dividers) {
        if (dividers == null) {
            dividers = ToolbarGroupDividerStrategy.NULL;
        }
        this.dividers = dividers;
        this.handleResized();
    }

    protected abstract void handleResized();

    public void setController(DockController controller) {
        this.factory.setController(controller);
    }

    public void reset(boolean force) {
        if (force || this.isOutdated()) {
            int i;
            this.columnSpans = new Span[this.grid.getColumnCount() + 1];
            for (i = 0; i < this.columnSpans.length; ++i) {
                this.columnSpans[i] = this.createSpan(true);
            }
            this.lineSpans = new Span[this.grid.getColumnCount()][];
            for (i = 0; i < this.lineSpans.length; ++i) {
                this.lineSpans[i] = new Span[this.grid.getLineCount(i) + 1];
                for (int j = 0; j < this.lineSpans[i].length; ++j) {
                    this.lineSpans[i][j] = this.createSpan(false);
                }
            }
            this.currentColumn = -1;
            this.currentLine = -1;
        }
    }

    private boolean isOutdated() {
        if (this.columnSpans.length != this.grid.getColumnCount() + 1) {
            return true;
        }
        for (int i = 0; i < this.lineSpans.length; ++i) {
            if (this.lineSpans[i].length == this.grid.getLineCount(i) + 1) continue;
            return true;
        }
        return false;
    }

    private Span createSpan(final boolean column) {
        return this.factory.create(new SpanCallback(){

            public void resized() {
                ToolbarGroupSpanStrategy.this.handleResized();
            }

            public boolean isVertical() {
                return ToolbarGroupSpanStrategy.this.station.getOrientation() == Orientation.HORIZONTAL ^ column;
            }

            public boolean isHorizontal() {
                return ToolbarGroupSpanStrategy.this.station.getOrientation() == Orientation.VERTICAL ^ column;
            }

            public SpanUsage getUsage() {
                return SpanUsage.INSERTING;
            }

            public DockStation getStation() {
                return ToolbarGroupSpanStrategy.this.station;
            }
        });
    }

    public int getColumn(int index) {
        return Math.max(this.columnSpans[index].getSize(), this.dividers.getColumn(index));
    }

    public int getLine(int column, int index) {
        return Math.max(this.lineSpans[column][index].getSize(), this.dividers.getLine(column, index));
    }

    public void mutate(int column) {
        this.mutate(column, -1);
    }

    public void mutate(int column, int line) {
        block10: {
            if (this.currentColumn == column && this.currentLine == line) break block10;
            this.currentColumn = column;
            this.currentLine = line;
            if (line == -1) {
                for (int i = 0; i < this.columnSpans.length; ++i) {
                    if (i == column) {
                        this.columnSpans[i].mutate(SpanMode.OPEN);
                        continue;
                    }
                    this.columnSpans[i].mutate(SpanMode.OFF);
                }
                Span[][] i = this.lineSpans;
                int n = i.length;
                for (int j = 0; j < n; ++j) {
                    Span[] spans;
                    for (Span span : spans = i[j]) {
                        span.mutate(SpanMode.OFF);
                    }
                }
            } else {
                for (Span span : this.columnSpans) {
                    span.mutate(SpanMode.OFF);
                }
                for (int i = 0; i < this.lineSpans.length; ++i) {
                    for (int j = 0; j < this.lineSpans[i].length; ++j) {
                        if (i == column && j == line) {
                            this.lineSpans[i][j].mutate(SpanMode.OPEN);
                            continue;
                        }
                        this.lineSpans[i][j].mutate(SpanMode.OFF);
                    }
                }
            }
        }
    }
}

