/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Orientation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationLayout;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.station.toolbar.layout.PerspectivePlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGridConverter;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

public class ToolbarGroupDockPerspective
implements PerspectiveStation,
PerspectiveDockable {
    private PerspectivePlaceholderToolbarGrid dockables;
    private PerspectiveStation parent;
    private ExpandedState state = ExpandedState.SHRUNK;
    private Orientation orientation = Orientation.HORIZONTAL;

    public ToolbarGroupDockPerspective() {
        this.dockables = new PerspectivePlaceholderToolbarGrid();
    }

    public ToolbarGroupDockPerspective(ToolbarGroupDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        this.dockables = new PerspectivePlaceholderToolbarGrid();
        this.read(layout, children);
    }

    public void read(ToolbarGroupDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        this.state = layout.getState();
        this.dockables.fromMap(layout.getPlaceholders(), children, new PlaceholderToolbarGridConverter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public PerspectiveDockable convert(PerspectiveDockable dockable, ConvertedPlaceholderListItem item) {
                return dockable;
            }

            @Override
            public void added(PerspectiveDockable item) {
                item.setParent((PerspectiveStation)ToolbarGroupDockPerspective.this);
            }
        });
        this.orientation = ToolbarGroupDockStationLayout.readOrientation(layout.getPlaceholders());
    }

    public PerspectivePlaceholderToolbarGrid getDockables() {
        return this.dockables;
    }

    public PlaceholderMap toMap(Map<PerspectiveDockable, Integer> children) {
        PlaceholderMap map = this.dockables.toMap(children);
        ToolbarGroupDockStationLayout.writeOrientation(map, this.orientation);
        return map;
    }

    public void setExpandedtState(ExpandedState state) {
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        this.state = state;
    }

    public ExpandedState getExpandedState() {
        return this.state;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public ToolbarColumnModel<PerspectiveDockable, PerspectiveDockable> getModel() {
        return this.dockables.getModel();
    }

    public PerspectiveDockable getDockable(int column, int line) {
        return this.getModel().getColumn((PerspectiveDockable)column).getDockable(line);
    }

    public int getColumnCount() {
        return this.dockables.getColumnCount();
    }

    public int getLineCount(int column) {
        return this.dockables.getLineCount(column);
    }

    public void add(int column, PerspectiveDockable dockable) {
        int line = 0;
        if (column >= 0 && column < this.getColumnCount()) {
            line = this.getLineCount(column);
        }
        this.insert(column, line, dockable);
    }

    public void insert(int column, int line, PerspectiveDockable dockable) {
        DockUtilities.ensureTreeValidity((PerspectiveStation)this, (PerspectiveDockable)dockable);
        this.dockables.insert(column, line, dockable);
        dockable.setParent((PerspectiveStation)this);
    }

    public void insert(int column, PerspectiveDockable dockable) {
        DockUtilities.ensureTreeValidity((PerspectiveStation)this, (PerspectiveDockable)dockable);
        this.dockables.insert(column, dockable);
        dockable.setParent((PerspectiveStation)this);
    }

    public void remove(int column, int line) {
        this.remove(this.getDockable(column, line));
    }

    public String getFactoryID() {
        return "ToolbarGroupDockStationFactory";
    }

    public PerspectiveStation asStation() {
        return this;
    }

    public PerspectiveDockable asDockable() {
        return this;
    }

    public Path getPlaceholder() {
        return null;
    }

    public PerspectiveStation getParent() {
        return this.parent;
    }

    public void setParent(PerspectiveStation parent) {
        this.parent = parent;
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public PerspectiveDockable getDockable(int index) {
        return (PerspectiveDockable)this.dockables.get(index);
    }

    public DockableProperty getDockableProperty(PerspectiveDockable child, PerspectiveDockable target) {
        int column = this.dockables.getColumn(child);
        int line = this.dockables.getLine(column, child);
        Path placeholder = target == null ? child.getPlaceholder() : target.getPlaceholder();
        return new ToolbarGroupProperty(column, line, placeholder);
    }

    public PlaceholderMap getPlaceholders() {
        PlaceholderMap map = this.dockables.toMap();
        ToolbarGroupDockStationLayout.writeOrientation(map, this.orientation);
        return map;
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        this.dockables.fromMap(placeholders);
    }

    public boolean remove(PerspectiveDockable dockable) {
        return this.dockables.remove(dockable);
    }

    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        this.dockables.replace(oldDockable, newDockable);
    }
}

