/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModeSettings<A, B> {
    private List<DockableEntry> dockables = new ArrayList<DockableEntry>();
    private Map<Path, ModeSetting<A>> modes = new HashMap<Path, ModeSetting<A>>();
    private ModeSettingsConverter<A, B> converter;
    private Map<Path, ModeSettingFactory<A>> factories = new HashMap<Path, ModeSettingFactory<A>>();

    public ModeSettings(ModeSettingsConverter<A, B> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        this.converter = converter;
    }

    public ModeSettingsConverter<A, B> getConverter() {
        return this.converter;
    }

    public void addFactory(ModeSettingFactory<A> factory) {
        this.factories.put(factory.getModeId(), factory);
    }

    public void add(String id, Path current, Map<Path, A> properties, Collection<Path> history) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        if (history == null) {
            throw new NullPointerException("history");
        }
        DockableEntry entry = new DockableEntry();
        entry.id = id;
        entry.current = current;
        entry.history = history.toArray(new Path[history.size()]);
        entry.properties = new HashMap();
        for (Map.Entry<Path, A> next : properties.entrySet()) {
            entry.properties.put(next.getKey(), this.converter.convertToSetting(next.getValue()));
        }
        this.dockables.add(entry);
    }

    public void add(Mode<A> mode) {
        ModeSettingFactory<A> factory = this.factories.get(mode.getUniqueIdentifier());
        if (factory == null) {
            throw new IllegalArgumentException("no factory present for '" + mode.getUniqueIdentifier() + "'");
        }
        ModeSetting<A> setting = factory.create();
        if (setting != null) {
            mode.writeSetting(setting);
            this.modes.put(setting.getModeId(), setting);
        }
    }

    public void add(ModeSetting<A> mode) {
        this.modes.put(mode.getModeId(), mode);
    }

    public int size() {
        return this.dockables.size();
    }

    public int indexOf(String id) {
        int index = 0;
        for (DockableEntry entry : this.dockables) {
            if (entry.id.equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getId(int index) {
        return this.dockables.get((int)index).id;
    }

    public Path getCurrent(int index) {
        return this.dockables.get((int)index).current;
    }

    public Path[] getHistory(int index) {
        return this.dockables.get((int)index).history;
    }

    public Map<Path, A> getProperties(int index) {
        HashMap<Path, A> result = new HashMap<Path, A>();
        for (Map.Entry entry : this.dockables.get((int)index).properties.entrySet()) {
            result.put(entry.getKey(), this.converter.convertToWorld(entry.getValue()));
        }
        return result;
    }

    public ModeSetting<A> getSettings(Path modeId) {
        return this.modes.get(modeId);
    }

    public void write(DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_0_8);
        out.writeInt(this.dockables.size());
        for (DockableEntry dockableEntry : this.dockables) {
            out.writeUTF(dockableEntry.id);
            if (dockableEntry.current == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(dockableEntry.current.toString());
            }
            out.writeInt(dockableEntry.history.length);
            for (Path history : dockableEntry.history) {
                out.writeUTF(history.toString());
            }
            out.writeInt(dockableEntry.properties.size());
            for (Map.Entry next : dockableEntry.properties.entrySet()) {
                out.writeUTF(next.getKey().toString());
                this.converter.writeProperty(next.getValue(), out);
            }
        }
        out.writeInt(this.modes.size());
        for (ModeSetting modeSetting : this.modes.values()) {
            out.writeUTF(modeSetting.getModeId().toString());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            modeSetting.write(dout, this.converter);
            out.writeInt(bout.size());
            bout.writeTo(out);
            dout.close();
        }
    }

    protected void rescueSettings(DataInputStream in, Version version) throws IOException {
    }

    protected void rescueSettings(XElement element) {
    }

    protected Path resuceMode(String identifier) {
        return null;
    }

    public void read(DataInputStream in) throws IOException {
        int count;
        int i;
        boolean version7;
        Version version = Version.read((DataInputStream)in);
        version.checkCurrent();
        boolean bl = version7 = Version.VERSION_1_0_7.compareTo(version) >= 0;
        if (version7) {
            Version.read((DataInputStream)in);
        }
        this.dockables.clear();
        int n = in.readInt();
        for (i = 0; i < n; ++i) {
            int j;
            DockableEntry entry = new DockableEntry();
            this.dockables.add(entry);
            entry.id = in.readUTF();
            if (in.readBoolean()) {
                String key = in.readUTF();
                entry.current = version7 ? this.resuceMode(key) : new Path(key);
            }
            entry.history = new Path[in.readInt()];
            for (j = 0; j < entry.history.length; ++j) {
                String key = in.readUTF();
                entry.history[j] = version7 ? this.resuceMode(key) : new Path(key);
            }
            if (version7) {
                count = 0;
                for (int j2 = 0; j2 < entry.history.length; ++j2) {
                    if (entry.history[j2] == null) continue;
                    ++count;
                }
                if (count != entry.history.length) {
                    Path[] temp = entry.history;
                    entry.history = new Path[count];
                    int index = 0;
                    for (int j3 = 0; j3 < temp.length; ++j3) {
                        if (temp[j3] == null) continue;
                        entry.history[index++] = temp[j3];
                    }
                }
            }
            entry.properties = new HashMap();
            int m = in.readInt();
            for (j = 0; j < m; ++j) {
                String key = in.readUTF();
                Path mode = version7 ? this.resuceMode(key) : new Path(key);
                B property = this.converter.readProperty(in);
                if (mode == null) continue;
                entry.properties.put(mode, property);
            }
        }
        this.modes.clear();
        if (version7) {
            this.rescueSettings(in, version);
        } else {
            n = in.readInt();
            for (i = 0; i < n; ++i) {
                int read;
                Path id = new Path(in.readUTF());
                count = in.readInt();
                byte[] content = new byte[count];
                int offset = 0;
                for (int length = count; length > 0 && (read = in.read(content, offset, length)) > 0; length -= read) {
                    offset += read;
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(content);
                DataInputStream din = new DataInputStream(bin);
                ModeSettingFactory<A> factory = this.factories.get(id);
                if (factory == null) continue;
                ModeSetting<A> setting = factory.create();
                setting.read(din, this.converter);
                din.close();
                this.modes.put(setting.getModeId(), setting);
            }
        }
    }

    public void writeXML(XElement element) {
        XElement delement = element.addElement("dockables");
        for (DockableEntry entry : this.dockables) {
            XElement xentry = delement.addElement("entry");
            xentry.addString("id", entry.id);
            if (entry.current != null) {
                xentry.addString("current", entry.current.toString());
            }
            XElement xhistory = xentry.addElement("history");
            for (Path history : entry.history) {
                xhistory.addElement("mode").setString(history.toString());
            }
            XElement xproperties = xentry.addElement("properties");
            for (Map.Entry next : entry.properties.entrySet()) {
                XElement xproperty = xproperties.addElement("property");
                xproperty.addString("id", next.getKey().toString());
                this.converter.writePropertyXML(next.getValue(), xproperty);
            }
        }
        XElement melement = element.addElement("modes");
        for (ModeSetting<A> mode : this.modes.values()) {
            XElement xmode = melement.addElement("entry");
            xmode.addString("id", mode.getModeId().toString());
            mode.write(xmode, this.converter);
        }
    }

    public void readXML(XElement element) {
        this.dockables.clear();
        XElement delement = element.getElement("dockables");
        if (delement != null) {
            for (XElement xentry : delement.getElements("entry")) {
                XElement xhistory;
                DockableEntry entry = new DockableEntry();
                this.dockables.add(entry);
                entry.id = xentry.getString("id");
                XAttribute current = xentry.getAttribute("current");
                if (current != null) {
                    entry.current = new Path(current.getString());
                }
                if ((xhistory = xentry.getElement("history")) == null) {
                    entry.history = new Path[0];
                } else {
                    XElement[] xmodes = xhistory.getElements("mode");
                    entry.history = new Path[xmodes.length];
                    for (int i = 0; i < xmodes.length; ++i) {
                        entry.history[i] = new Path(xmodes[i].getString());
                    }
                }
                XElement xproperties = xentry.getElement("properties");
                entry.properties = new HashMap();
                if (xproperties == null) continue;
                for (XElement xproperty : xproperties.getElements("property")) {
                    entry.properties.put(new Path(xproperty.getString("id")), this.converter.readPropertyXML(xproperty));
                }
            }
        }
        this.modes.clear();
        XElement melement = element.getElement("modes");
        if (melement != null) {
            for (XElement xmode : melement.getElements("entry")) {
                Path id = new Path(xmode.getString("id"));
                ModeSettingFactory<A> factory = this.factories.get(id);
                if (factory == null) continue;
                ModeSetting<A> setting = factory.create();
                setting.read(xmode, this.converter);
                this.modes.put(setting.getModeId(), setting);
            }
        } else {
            this.rescueSettings(element);
        }
    }

    private class DockableEntry {
        public String id;
        public Path current;
        public Map<Path, B> properties;
        public Path[] history;

        private DockableEntry() {
        }
    }
}

