/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.intern.CPlaceholderStrategy;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStackPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonDockStationPerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModeAreaPerspective;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.CModeAreaPerspective;
import bibliothek.gui.dock.common.perspective.mode.CNormalModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModeManagerPerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.split.GridNode;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockGrid;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPerspective;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.util.List;

public class CGridPerspective
extends SingleCDockablePerspective
implements CStationPerspective {
    private CommonSplitDockPerspective delegate;
    private PerspectiveSplitDockGrid grid;
    private boolean autoDeploy = true;
    private boolean gridChanges = false;
    private boolean onDeploy = false;
    private CPerspective perspective;
    private Path unmaximizeMode;
    private Location unmaximizeLocation;
    private boolean workingArea;
    private Path typeId;
    private boolean root = true;
    private CModeAreaPerspective normalMode = new CModeAreaPerspective(){

        @Override
        public String getUniqueId() {
            return CGridPerspective.this.getUniqueId();
        }

        @Override
        public boolean isChild(PerspectiveDockable dockable) {
            if (dockable.getParent() == CGridPerspective.this.intern()) {
                return CGridPerspective.this.delegate().getFullscreen() != dockable;
            }
            return false;
        }

        @Override
        public boolean isChildLocation(DockableProperty location) {
            return location instanceof SplitDockProperty || location instanceof SplitDockPathProperty || location instanceof SplitDockPlaceholderProperty;
        }
    };
    private CMaximizedModeAreaPerspective maximalMode = new CMaximizedModeAreaPerspective(){

        @Override
        public String getUniqueId() {
            return CGridPerspective.this.getUniqueId();
        }

        @Override
        public boolean isChild(PerspectiveDockable dockable) {
            if (dockable.getParent() == CGridPerspective.this.intern()) {
                return CGridPerspective.this.delegate().getFullscreen() == dockable;
            }
            return false;
        }

        @Override
        public void setUnmaximize(Path mode, Location location) {
            CGridPerspective.this.unmaximizeLocation = location;
            CGridPerspective.this.unmaximizeMode = mode;
        }

        @Override
        public Location getUnmaximizeLocation() {
            return CGridPerspective.this.unmaximizeLocation;
        }

        @Override
        public Path getUnmaximizeMode() {
            return CGridPerspective.this.unmaximizeMode;
        }

        @Override
        public boolean isChildLocation(DockableProperty location) {
            return location instanceof SplitDockFullScreenProperty;
        }
    };

    public CGridPerspective(String id) {
        this(id, null);
    }

    public CGridPerspective(String id, Path typeId) {
        this(id, typeId, false);
    }

    public CGridPerspective(String id, Path typeId, boolean workingArea) {
        super(id);
        this.delegate = new CommonSplitDockPerspective();
        this.delegate.setHasFullscreenAction(false);
        this.setWorkingArea(workingArea);
        this.gridClear();
        if (typeId == null) {
            typeId = CGridArea.TYPE_ID;
        }
        this.typeId = typeId;
    }

    @Override
    public boolean isWorkingArea() {
        return this.workingArea;
    }

    @Override
    public Path getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setWorkingArea(boolean workingArea) {
        this.workingArea = workingArea;
    }

    @Override
    protected CommonSplitDockPerspective create() {
        return this.delegate;
    }

    private CommonSplitDockPerspective delegate() {
        return this.intern();
    }

    @Override
    public CommonSplitDockPerspective intern() {
        return (CommonSplitDockPerspective)super.intern();
    }

    @Override
    public void setPerspective(CPerspective perspective) {
        if (this.perspective != null) {
            ((CNormalModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.NORMALIZED)).remove(this.normalMode);
            ((CMaximizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MAXIMIZED)).remove(this.maximalMode);
        }
        this.perspective = perspective;
        if (this.perspective != null) {
            ((CNormalModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.NORMALIZED)).add(this.normalMode);
            ((CMaximizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MAXIMIZED)).add(this.maximalMode);
        }
    }

    @Override
    public CPerspective getPerspective() {
        return this.perspective;
    }

    protected void maybeDeploy() {
        if (this.isAutoDeploy() && this.gridChanges) {
            this.gridDeploy();
        }
    }

    private PerspectiveDockable[] convert(CDockablePerspective[] dockables) {
        PerspectiveDockable[] result = new PerspectiveDockable[dockables.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dockables[i].intern().asDockable();
        }
        return result;
    }

    public void unpack(double x, double y, double width, double height) {
        this.gridChanges = true;
        this.grid.unpack(x, y, width, height);
    }

    public void gridAdd(double x, double y, double width, double height, CDockablePerspective ... dockables) {
        this.gridChanges = true;
        this.grid.addDockable(x, y, width, height, (Object[])this.convert(dockables));
    }

    public void gridPlaceholder(double x, double y, double width, double height, CDockablePerspective ... dockables) {
        this.gridChanges = true;
        Path[] placeholders = new Path[dockables.length];
        for (int i = 0; i < dockables.length; ++i) {
            placeholders[i] = dockables[i].intern().asDockable().getPlaceholder();
            if (placeholders[i] != null) continue;
            throw new IllegalArgumentException("dockable '" + i + "' does not have a placeholder: " + dockables[i]);
        }
        this.grid.addPlaceholders(x, y, width, height, placeholders);
    }

    public void gridPlaceholder(double x, double y, double width, double height, Path ... placeholders) {
        this.gridChanges = true;
        this.grid.addPlaceholders(x, y, width, height, placeholders);
    }

    public void gridSelect(double x, double y, double width, double height, CDockablePerspective selection) {
        this.gridChanges = true;
        this.grid.setSelected(x, y, width, height, selection == null ? null : selection.intern().asDockable());
    }

    public void gridHorizontal(double x1, double x2, double y) {
        this.gridChanges = true;
        this.grid.addHorizontalDivider(x1, x2, y);
    }

    public void gridVertical(double x, double y1, double y2) {
        this.gridChanges = true;
        this.grid.addVerticalDivider(x, y1, y2);
    }

    public void gridClear() {
        this.grid = new PerspectiveSplitDockGrid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gridDeploy() {
        if (this.gridChanges) {
            this.gridChanges = false;
            try {
                this.onDeploy = true;
                this.delegate().read(this.grid.toTree(), null);
            }
            finally {
                this.onDeploy = false;
            }
        }
    }

    public void gridPrepare() {
        this.gridChanges = false;
        this.gridClear();
        this.handle(this.delegate().getRoot().getChild(), 0.0, 0.0, 100.0, 100.0);
    }

    private void handle(SplitDockPerspective.Entry entry, double x, double y, double width, double height) {
        if (entry != null) {
            if (entry.asLeaf() != null) {
                PerspectiveDockable dockable = entry.asLeaf().getDockable();
                if (dockable != null) {
                    this.grid.addDockable(x, y, width, height, (Object[])new PerspectiveDockable[]{dockable});
                }
            } else {
                SplitDockPerspective.Node node = entry.asNode();
                double divider = node.getDivider();
                if (node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    this.handle(node.getChildA(), x, y, width * divider, height);
                    this.handle(node.getChildB(), x + width * divider, y, width * (1.0 - divider), height);
                } else {
                    this.handle(node.getChildA(), x, y, width, height * divider);
                    this.handle(node.getChildB(), x, y + height * divider, width, height * (1.0 - divider));
                }
            }
        }
    }

    public PerspectiveSplitDockGrid grid() {
        this.gridChanges = true;
        return this.grid;
    }

    public List<GridNode<PerspectiveDockable>> getGridNodes() {
        return this.grid.getGridNodes();
    }

    public void setAutoDeploy(boolean autoDeploy) {
        this.autoDeploy = autoDeploy;
    }

    public boolean isAutoDeploy() {
        return this.autoDeploy;
    }

    public SplitDockPerspective.Root getRoot() {
        return this.delegate().getRoot();
    }

    public void maximize(CDockablePerspective dockable) {
        this.maximize(dockable.intern().asDockable());
    }

    public void maximize(PerspectiveDockable dockable) {
        this.maybeDeploy();
        LocationModeManagerPerspective manager = this.perspective.getLocationManager();
        Location location = manager.getLocation(dockable);
        Path mode = null;
        if (location == null) {
            ExtendedMode eMode = manager.getMode(dockable);
            if (eMode != null) {
                mode = eMode.getModeIdentifier();
            }
        } else {
            mode = location.getMode();
        }
        if (dockable.getParent() != this.intern()) {
            if (dockable.getParent() != null) {
                dockable.getParent().remove(dockable);
            }
            SplitDockPerspective.Root root = this.getRoot();
            SplitDockPerspective.Leaf leaf = new SplitDockPerspective.Leaf(dockable, null, null, -1L);
            if (root.getChild() == null) {
                root.setChild((SplitDockPerspective.Entry)leaf);
            } else {
                root.setChild((SplitDockPerspective.Entry)new SplitDockPerspective.Node(SplitDockStation.Orientation.HORIZONTAL, 0.5, (SplitDockPerspective.Entry)leaf, root.getChild(), null, null, -1L));
            }
        }
        this.delegate.setFullscreen(dockable);
        this.unmaximizeLocation = location;
        this.unmaximizeMode = mode;
    }

    public PerspectiveDockable getMaximized() {
        return this.delegate().getFullscreen();
    }

    @Override
    public CStationPerspective asStation() {
        return this;
    }

    public String getFactoryID() {
        return this.delegate().getFactoryID();
    }

    public PlaceholderMap getPlaceholders() {
        return this.delegate().getPlaceholders();
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        this.delegate().setPlaceholders(placeholders);
    }

    public class CommonSplitDockPerspective
    extends SplitDockPerspective
    implements CommonDockStationPerspective {
        @Override
        public CElementPerspective getElement() {
            return CGridPerspective.this;
        }

        @Override
        public String getFactoryID() {
            return "CommonDockStationFactory";
        }

        @Override
        public String getConverterID() {
            return super.getFactoryID();
        }

        public void read(PerspectiveSplitDockTree tree, PerspectiveDockable fullscreen) {
            super.read(tree, fullscreen);
            if (!CGridPerspective.this.onDeploy) {
                CGridPerspective.this.gridPrepare();
            }
        }

        protected PerspectiveDockable combine(PerspectiveDockable[] dockables, PerspectiveDockable selection) {
            return new CStackPerspective(dockables, selection);
        }

        public Path getPlaceholder() {
            return CPlaceholderStrategy.getSingleDockablePlaceholder(CGridPerspective.this.getUniqueId());
        }

        public SplitDockPerspective.Root getRoot() {
            CGridPerspective.this.maybeDeploy();
            return super.getRoot();
        }

        public int getDockableCount() {
            CGridPerspective.this.maybeDeploy();
            return super.getDockableCount();
        }

        public PerspectiveDockable getDockable(int index) {
            CGridPerspective.this.maybeDeploy();
            return super.getDockable(index);
        }
    }
}

