/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseHandler
implements Closeable,
Runnable {
    protected Closeable closeable = null;
    protected Runnable runnable = null;
    public static final CloseHandler dummy = new CloseHandler(){

        @Override
        public void closeHandler() {
        }
    };

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CloseHandler.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CloseHandler.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CloseHandler.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CloseHandler.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CloseHandler.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CloseHandler.class.getName()).log(Level.SEVERE, null, ex);
    }

    public CloseHandler() {
    }

    public CloseHandler(Closeable c) {
        this.closeable = c;
    }

    public CloseHandler(Runnable r) {
        this.runnable = r;
    }

    public CloseHandler(Closeable c, Runnable r) {
        this.closeable = c;
        this.runnable = r;
    }

    @Override
    public void close() throws IOException {
        this.closeHandler();
    }

    @Override
    public void run() {
        this.closeHandler();
    }

    public void closeHandler() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CloseHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.closeable = null;
        }
        if (this.runnable != null) {
            this.runnable.run();
            this.runnable = null;
        }
    }
}

