/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.io.Closeable;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeListener;
import xyz.cofe.collection.tree.TreeNodeListeners;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;

public class TreeNodeListenersDef {
    private static final Logger logger = Logger.getLogger(TreeNodeListenersDef.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    public static final WeakHashMap<TreeNode, ListenersHelper> listeners;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeListenersDef.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeListenersDef.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeListenersDef.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenersHelper<TreeNodeListener, TreeNodeEvent> getListenersHelper(TreeNodeListeners self) {
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            ListenersHelper<TreeNodeListener, TreeNodeEvent> listener = listeners.get(self);
            if (listener == null) {
                listener = new ListenersHelper<TreeNodeListener, TreeNodeEvent>(new Func2<Object, TreeNodeListener, TreeNodeEvent>(){

                    @Override
                    public Object apply(TreeNodeListener arg1, TreeNodeEvent arg2) {
                        if (arg1 != null) {
                            arg1.treeNodeEvent(arg2);
                        }
                        return null;
                    }
                });
                listeners.put(self, listener);
            }
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable addTreeNodeListener(TreeNodeListeners lsrs, TreeNodeListener lsr) {
        if (lsr == null) {
            throw new IllegalArgumentException("lsr==null");
        }
        if (lsrs == null) {
            throw new IllegalArgumentException("lsrs==null");
        }
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            return TreeNodeListenersDef.getListenersHelper(lsrs).addListener(lsr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable addTreeNodeListener(TreeNodeListeners lsrs, TreeNodeListener lsr, boolean weakLink) {
        if (lsr == null) {
            throw new IllegalArgumentException("lsr==null");
        }
        if (lsrs == null) {
            throw new IllegalArgumentException("lsrs==null");
        }
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            return TreeNodeListenersDef.getListenersHelper(lsrs).addListener(lsr, weakLink);
        }
    }

    public static <EventType extends TreeNodeEvent> Closeable onTreeNodeEvent(TreeNodeListeners lsrs, final Class<EventType> cls, boolean weakLink, final Reciver<? super EventType> consumer) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer==null");
        }
        return TreeNodeListenersDef.addTreeNodeListener(lsrs, new TreeNodeListener(){

            public void treeNodeEvent(TreeNodeEvent ev) {
                Class<?> c;
                if (ev != null && cls.isAssignableFrom(c = ev.getClass())) {
                    consumer.recive(ev);
                }
            }
        }, weakLink);
    }

    public static <EventType extends TreeNodeEvent> Closeable onTreeNodeEvent(TreeNodeListeners lsrs, Class<EventType> cls, Reciver<? super EventType> consumer) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer==null");
        }
        return TreeNodeListenersDef.onTreeNodeEvent(lsrs, cls, false, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireTreeNodeEvent(TreeNodeListeners lsrs, TreeNodeEvent ev) {
        if (ev == null) {
            throw new IllegalArgumentException("ev==null");
        }
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            TreeNodeListenersDef.getListenersHelper(lsrs).fireEvent(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTreeNodeListener(TreeNodeListeners lsrs, TreeNodeListener lsr) {
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            return TreeNodeListenersDef.getListenersHelper(lsrs).hasListener(lsr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTreeNodeListener(TreeNodeListeners lsrs, TreeNodeListener lsr) {
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            TreeNodeListenersDef.getListenersHelper(lsrs).removeListener(lsr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<TreeNodeListener> getTreeNodeListeners(TreeNodeListeners lsrs) {
        WeakHashMap<TreeNode, ListenersHelper> weakHashMap = listeners;
        synchronized (weakHashMap) {
            return TreeNodeListenersDef.getListenersHelper(lsrs).getListeners();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        listeners = new WeakHashMap();
    }
}

