/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.SyncEventList;
import xyz.cofe.collection.tree.IndexTreeNode;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeListener;
import xyz.cofe.common.Reciver;

public abstract class SyncTreeNode<Node extends TreeNode>
extends IndexTreeNode<Node> {
    private static final Logger logger = Logger.getLogger(SyncTreeNode.class.getName());
    protected final Object sync;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = SyncTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = SyncTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = SyncTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = SyncTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = SyncTreeNode.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = SyncTreeNode.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(SyncTreeNode.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(SyncTreeNode.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(SyncTreeNode.class.getName(), method);
    }

    public SyncTreeNode() {
        this.sync = this;
    }

    public SyncTreeNode(Object sync) {
        this.sync = sync == null ? this : sync;
    }

    @Override
    protected EventList<Node> createEventList() {
        return (EventList)this.syncrun(new Func0(){

            public Object apply() {
                return new SyncEventList(new LinkedList(), SyncTreeNode.this.sync);
            }
        }, "createEventList", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object syncrun(Func0 run, String method, Object ... args) {
        Object object = this.sync;
        synchronized (object) {
            return run.apply();
        }
    }

    @Override
    public int getRootOffset() {
        return (Integer)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.getRootOffset();
            }
        }, "getRootOffset", new Object[0]);
    }

    @Override
    public Node deepOffset(final int offset) {
        return (Node)((TreeNode)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.deepOffset(offset);
            }
        }, "deepOffset", offset));
    }

    @Override
    public int getNodesCount() {
        return (Integer)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.getNodesCount();
            }
        }, "getNodesCount", new Object[0]);
    }

    @Override
    public void popup(final TreeNodeEvent<Node> ev) {
        this.syncrun(new Func0(){

            public Object apply() {
                SyncTreeNode.super.popup(ev);
                return null;
            }
        }, "popup", ev);
    }

    @Override
    public void assignParentTo(final Object inserted) {
        this.syncrun(new Func0(){

            public Object apply() {
                SyncTreeNode.super.assignParentTo(inserted);
                return null;
            }
        }, "assignParentTo", inserted);
    }

    @Override
    public Set<TreeNodeListener> getTreeNodeListeners() {
        return (Set)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.getTreeNodeListeners();
            }
        }, "getTreeNodeListeners", new Object[0]);
    }

    @Override
    public void removeTreeNodeListener(final TreeNodeListener<Node> lsr) {
        this.syncrun(new Func0(){

            public Object apply() {
                SyncTreeNode.super.removeTreeNodeListener(lsr);
                return null;
            }
        }, "removeTreeNodeListener", lsr);
    }

    @Override
    public boolean hasTreeNodeListener(final TreeNodeListener<Node> lsr) {
        return (Boolean)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.hasTreeNodeListener(lsr);
            }
        }, "hasTreeNodeListener", lsr);
    }

    @Override
    public void fireTreeNodeEvent(final TreeNodeEvent<Node> ev) {
        this.syncrun(new Func0(){

            public Object apply() {
                SyncTreeNode.super.fireTreeNodeEvent(ev);
                return null;
            }
        }, "fireTreeNodeEvent", ev);
    }

    @Override
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent(final Class<EventType> cls, final Reciver<? super EventType> consumer) {
        return (Closeable)this.syncrun(new Func0(){

            public Object apply() {
                Reciver r = consumer;
                Class c = cls;
                return SyncTreeNode.super.onTreeNodeEvent(c, r);
            }
        }, "onTreeNodeEvent", cls, consumer);
    }

    @Override
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent(final Class<EventType> cls, final boolean weakLink, final Reciver<? super EventType> consumer) {
        return (Closeable)this.syncrun(new Func0(){

            public Object apply() {
                Class c = cls;
                Reciver r = consumer;
                return SyncTreeNode.super.onTreeNodeEvent(c, weakLink, r);
            }
        }, "onTreeNodeEvent", cls, weakLink, consumer);
    }

    @Override
    public Closeable addTreeNodeListener(final TreeNodeListener<Node> lsr, final boolean weakLink) {
        return (Closeable)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.addTreeNodeListener(lsr, weakLink);
            }
        }, "addTreeNodeListener", lsr, weakLink);
    }

    @Override
    public Closeable addTreeNodeListener(final TreeNodeListener<Node> lsr) {
        return (Closeable)this.syncrun(new Func0(){

            public Object apply() {
                return SyncTreeNode.super.addTreeNodeListener(lsr);
            }
        }, "addTreeNodeListener", lsr);
    }
}

