/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.collection.tree.AbstractTreeNode;
import xyz.cofe.collection.tree.OnTreeNodeAdded;
import xyz.cofe.collection.tree.OnTreeNodeAdding;
import xyz.cofe.collection.tree.OnTreeNodeRemoved;
import xyz.cofe.collection.tree.OnTreeNodeRemoving;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAppendChild;
import xyz.cofe.collection.tree.TreeNodeAssignSelfParent;
import xyz.cofe.collection.tree.TreeNodeChildrenList;
import xyz.cofe.collection.tree.TreeNodeInsertChild;
import xyz.cofe.collection.tree.TreeNodeRemoveChild;
import xyz.cofe.collection.tree.TreeNodeRemoveChildAt;
import xyz.cofe.collection.tree.TreeNodeReplaceChild;
import xyz.cofe.collection.tree.TreeNodeSetParent;
import xyz.cofe.collection.tree.TreeNodeUpdateParent;

public abstract class BasicTreeNode<Node extends TreeNode>
extends AbstractTreeNode<Node>
implements TreeNodeAppendChild<Node>,
TreeNodeChildrenList<Node>,
TreeNodeInsertChild<Node>,
TreeNodeRemoveChild<Node>,
TreeNodeRemoveChildAt,
TreeNodeReplaceChild<Node>,
OnTreeNodeAdded<Node>,
OnTreeNodeAdding<Node>,
OnTreeNodeRemoved<Node>,
OnTreeNodeRemoving<Node>,
TreeNodeAssignSelfParent<Node> {
    private static final Logger logger = Logger.getLogger(BasicTreeNode.class.getName());
    private static final Level logLevel = logger.getLevel();
    private EventList<Node> childrenList;
    protected final SimpleListAdapter<Node> notifyListener = new SimpleListAdapter<Node>(){

        @Override
        protected void added(Node e, EventList<Node> list, Integer position) {
            BasicTreeNode.this.onTreeNodeAdded(position, e);
        }

        @Override
        protected void adding(Node e, EventList<Node> list, Integer position) {
            BasicTreeNode.this.onTreeNodeAdding(position, e);
        }

        @Override
        protected void removed(Node e, EventList<Node> list, Integer position) {
            BasicTreeNode.this.onTreeNodeRemoved(position, e);
        }

        @Override
        protected void removing(Node e, EventList<Node> list, Integer position) {
            BasicTreeNode.this.onTreeNodeRemoving(position, e);
        }
    };

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Override
    public EventList<Node> getChildrenList() {
        return (EventList)this.syncrun(new Func0(){

            public Object apply() {
                if (BasicTreeNode.this.childrenList != null) {
                    return BasicTreeNode.this.childrenList;
                }
                BasicTreeNode.this.childrenList = BasicTreeNode.this.createEventList();
                if (BasicTreeNode.this.childrenList != null) {
                    BasicTreeNode.this.attachListeners(BasicTreeNode.this.childrenList);
                }
                return BasicTreeNode.this.childrenList;
            }
        }, "getChildrenList", new Object[0]);
    }

    protected EventList<Node> createEventList() {
        return (EventList)this.syncrun(new Func0(){

            public Object apply() {
                return new IndexEventList();
            }
        }, "createEventList", new Object[0]);
    }

    protected void attachListeners(final EventList<Node> elist) {
        this.syncrun(new Func0(){

            public Object apply() {
                if (elist != null) {
                    elist.addEventListListener(BasicTreeNode.this.notifyListener, true);
                }
                return null;
            }
        }, "attachListeners", elist);
    }

    @Override
    public void onTreeNodeAdded(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child){
            final /* synthetic */ TreeNode val$child;
            {
                this.val$child = treeNode;
            }

            public Object apply() {
                BasicTreeNode.this.assignParentTo(this.val$child);
                return null;
            }
        }, "onTreeNodeAdded", index, child);
    }

    protected void assignParentTo(Object inserted) {
        if (inserted instanceof TreeNodeSetParent) {
            TreeNodeSetParent tn = (TreeNodeSetParent)inserted;
            tn.setParent(this);
        }
    }

    @Override
    public void onTreeNodeAdding(Integer index, Node child) {
    }

    @Override
    public void onTreeNodeRemoved(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child){
            final /* synthetic */ TreeNode val$child;
            {
                this.val$child = treeNode;
            }

            public Object apply() {
                BasicTreeNode.this.resetParent(this.val$child);
                return null;
            }
        }, "onTreeNodeRemoved", index, child);
    }

    protected void resetParent(Node child) {
        if (child instanceof TreeNodeUpdateParent) {
            ((TreeNodeUpdateParent)child).updateParent(this, null);
        }
    }

    @Override
    public void onTreeNodeRemoving(Integer index, Node child) {
    }

    @Override
    public Node appendChild(Node child) {
        if (child == null) {
            throw new IllegalArgumentException("child==null");
        }
        this.syncrun(new Func0((TreeNode)child){
            final /* synthetic */ TreeNode val$child;
            {
                this.val$child = treeNode;
            }

            public Object apply() {
                BasicTreeNode.this.getChildrenList().add(this.val$child);
                return null;
            }
        }, "appendChild", child);
        return (Node)this;
    }

    @Override
    public void insertChildAt(final int index, Node child) {
        if (child == null) {
            throw new IllegalArgumentException("child==null");
        }
        this.syncrun(new Func0((TreeNode)child){
            final /* synthetic */ TreeNode val$child;
            {
                this.val$child = treeNode;
            }

            public Object apply() {
                BasicTreeNode.this.getChildrenList().add(index, this.val$child);
                return null;
            }
        }, "insertChildAt", index, child);
    }

    @Override
    public void removeChild(Node child) {
        this.syncrun(new Func0((TreeNode)child){
            final /* synthetic */ TreeNode val$child;
            {
                this.val$child = treeNode;
            }

            public Object apply() {
                BasicTreeNode.this.getChildrenList().remove(this.val$child);
                return null;
            }
        }, "removeChild", child);
    }

    @Override
    public void removeChildAt(final int idx) {
        this.syncrun(new Func0(){

            public Object apply() {
                BasicTreeNode.this.getChildrenList().remove(idx);
                return null;
            }
        }, "removeChildAt", idx);
    }

    @Override
    public void setChild(int index, Node node) {
        this.syncrun(new Func0((TreeNode)node, index){
            final /* synthetic */ TreeNode val$node;
            final /* synthetic */ int val$index;
            {
                this.val$node = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                if (this.val$node == null) {
                    throw new IllegalArgumentException("node==null");
                }
                BasicTreeNode.this.getChildrenList().set(this.val$index, this.val$node);
                return null;
            }
        }, "setChild", index, node);
    }
}

