/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.BasicEventList;
import xyz.cofe.collection.list.RemovedPositionalEvent;
import xyz.cofe.collection.list.RemovingPositionalEvent;

public class IndexIterator<E>
implements Iterator<E> {
    protected BasicEventList<E> elist = null;
    protected Iterator<E> itr = null;
    protected E current = null;
    protected int index = -1;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(IndexIterator.class.getName()).log(Level.SEVERE, null, ex);
    }

    public IndexIterator(BasicEventList<E> elist, Iterator<E> srcItr) {
        if (elist == null) {
            throw new IllegalArgumentException("elist==null");
        }
        if (srcItr == null) {
            throw new IllegalArgumentException("srcItr==null");
        }
        this.elist = elist;
        this.itr = srcItr;
    }

    @Override
    public boolean hasNext() {
        if (this.itr != null) {
            boolean r = this.itr.hasNext();
            if (!r) {
                this.itr = null;
                this.elist = null;
            }
            return r;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.itr != null) {
            ++this.index;
            E r = this.itr.next();
            this.current = r;
            return r;
        }
        return null;
    }

    @Override
    public void remove() {
        if (this.itr != null) {
            if (this.current != null && this.elist != null) {
                this.elist.fireEventListMessage(new RemovingPositionalEvent<E>(this.current, this.elist, this.index));
            }
            this.itr.remove();
            if (this.current != null && this.elist != null) {
                this.elist.fireEventListMessage(new RemovedPositionalEvent<E>(this.current, this.elist, this.index));
            }
            --this.index;
        }
    }
}

