/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;
import xyz.cofe.collection.iterators.CompareEqu;

public class SubIterator<T>
implements Iterator<T> {
    private Iterable<T> sub = null;
    private Iterator<T> src = null;
    private CompareEqu<T> cmp = null;
    private T current = null;

    public SubIterator(Iterable<T> src, Iterable<T> sub, CompareEqu<T> cmp) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (sub == null) {
            throw new IllegalArgumentException("sub == null");
        }
        if (cmp == null) {
            throw new IllegalArgumentException("cmp == null");
        }
        this.reinit(src, sub, cmp);
    }

    public void reinit(Iterable<T> src, Iterable<T> sub, CompareEqu<T> cmp) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (sub == null) {
            throw new IllegalArgumentException("sub == null");
        }
        if (cmp == null) {
            throw new IllegalArgumentException("cmp == null");
        }
        this.src = src.iterator();
        this.sub = sub;
        this.cmp = cmp;
        this.current = this.findNext();
    }

    private boolean checkIn(T v, Iterable<T> sub) {
        for (T c : sub) {
            if (!this.cmp.isEqu(v, c)) continue;
            return true;
        }
        return false;
    }

    private T findNext() {
        if (this.src == null) {
            return null;
        }
        while (this.src.hasNext()) {
            T v = this.src.next();
            if (v == null || this.checkIn(v, this.sub)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public T next() {
        T res = this.current;
        this.current = this.findNext();
        return res;
    }

    @Override
    public void remove() {
    }
}

