/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;
import java.util.List;
import xyz.cofe.collection.iterators.CompareEqu;

public class SetIterator<T>
implements Iterator<T> {
    private List<T> list = null;
    private CompareEqu<T> cmp = null;
    private Iterator<T> src = null;
    private T current = null;

    public SetIterator(Iterator<T> src, CompareEqu<T> cmp, List<T> buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer == null");
        }
        if (cmp == null) {
            throw new IllegalArgumentException("cmp == null");
        }
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        this.list = buffer;
        this.src = src;
        this.cmp = cmp;
        this.list.clear();
        this.current = this.findNext();
    }

    private T findNext() {
        while (this.src.hasNext()) {
            T v = this.src.next();
            if (v == null) continue;
            boolean duplicate = false;
            for (T history : this.list) {
                if (!this.cmp.isEqu(history, v)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            this.list.add(v);
            return v;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public T next() {
        T result = this.current;
        this.current = this.findNext();
        return result;
    }

    @Override
    public void remove() {
    }

    public List<T> getBuffert() {
        return this.list;
    }
}

