/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;
import xyz.cofe.collection.Predicate;

public class PredicateIterator<T>
implements Iterator<T> {
    protected Iterator<T> iterator = null;
    protected Predicate<T> predicate = null;
    protected T current = null;
    protected boolean hasNext = false;

    public PredicateIterator(Predicate<T> predicate, Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("predicate  == null");
        }
        this.iterator = iterator;
        this.predicate = predicate;
        this.findNext();
    }

    protected void findNext() {
        Object obj = null;
        while (this.iterator.hasNext()) {
            obj = this.iterator.next();
            if (!this.predicate.validate(obj)) continue;
            this.current = obj;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
        this.current = null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            return null;
        }
        T result = this.current;
        this.findNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

