/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import xyz.cofe.collection.graph.DefaultGraphFactory;
import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.GraphFactory;
import xyz.cofe.collection.graph.MultipleDirectedGraph;

public class SimpleMDGraph<N, E>
implements MultipleDirectedGraph<N, E> {
    protected GraphFactory<N, E> factory = null;
    protected Collection<Edge<N, E>> edges = null;
    protected Collection<N> nodes = null;

    public SimpleMDGraph() {
        this(new DefaultGraphFactory());
    }

    public SimpleMDGraph(GraphFactory<N, E> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory == null");
        }
        this.factory = factory;
        this.edges = factory.createEdgePairs();
        this.nodes = factory.createNodes();
    }

    @Override
    public Iterable<N> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Edge<N, E>> getEdges() {
        return this.edges;
    }

    @Override
    public boolean contains(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        return this.indexOf(node) >= 0;
    }

    protected int indexOf(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        int idx = -1;
        for (N n : this.nodes) {
            ++idx;
            if (!n.equals(node)) continue;
            return idx;
        }
        return -1;
    }

    @Override
    public E getEdge(N a, N b) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Iterator<E> iterator = this.get(a, b).iterator();
        if (iterator.hasNext()) {
            E e = iterator.next();
            return e;
        }
        return null;
    }

    @Override
    public Iterable<E> getEdges(N a, N b) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Iterable<E> en = this.get(a, b);
        if (en == null) {
            return new ArrayList();
        }
        return en;
    }

    @Override
    public boolean hasEdge(N a, N b) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Iterable<E> en = this.get(a, b);
        if (en == null) {
            return false;
        }
        return false;
    }

    @Override
    public Iterable<Edge<N, E>> edgesOf(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        Collection<Edge<N, Edge<N, E>>> list = this.factory.createEdgePairs();
        for (Edge<N, E> e : this.edges) {
            if (!e.getNodeA().equals(node) && !e.getNodeB().equals(node)) continue;
            list.add(e);
        }
        return list;
    }

    @Override
    public Iterable<Edge<N, E>> edgesOfNodeA(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        Collection<Edge<N, Edge<N, E>>> list = this.factory.createEdgePairs();
        for (Edge<N, E> e : this.edges) {
            if (!e.getNodeA().equals(node)) continue;
            list.add(e);
        }
        return list;
    }

    @Override
    public Iterable<Edge<N, E>> edgesOfNodeB(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        Collection<Edge<N, Edge<N, E>>> list = this.factory.createEdgePairs();
        for (Edge<N, E> e : this.edges) {
            if (!e.getNodeB().equals(node)) continue;
            list.add(e);
        }
        return list;
    }

    protected void onEdgeRemoved(Edge<N, E> es) {
    }

    protected void onEdgeAdded(Edge<N, E> es) {
    }

    protected void onNodeAdded(N node) {
    }

    protected void onNodeRemoved(N node) {
    }

    @Override
    public Iterable<E> get(N a, N b) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Collection<E> list = this.factory.createEdges();
        for (Edge<N, E> e : this.edges) {
            if (!e.getNodeA().equals(a) || !e.getNodeB().equals(b)) continue;
            list.add(e.getEdge());
        }
        return list;
    }

    @Override
    public void set(N a, N b, Iterable<E> e) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        if (!this.contains(a)) {
            this.add(a);
        }
        if (!this.contains(b)) {
            this.add(b);
        }
        Collection<Edge<N, Edge<N, E>>> oldEdgeslist = this.factory.createEdgePairs();
        for (Edge<N, E> edge : this.edges) {
            if (!edge.getNodeA().equals(a) || !edge.getNodeB().equals(b)) continue;
            oldEdgeslist.add(edge);
        }
        for (Edge<N, E> edge : oldEdgeslist) {
            this.remove((N)edge);
        }
        if (e != null) {
            for (Edge<N, E> edge : e) {
                if (edge == null) continue;
                Edge<N, Edge<N, E>> newESet = this.factory.createEdge(a, b, edge);
                this.add((N)newESet);
            }
        }
    }

    @Override
    protected void remove(Edge<N, E> es) {
        if (es == null) {
            throw new IllegalArgumentException("es == null");
        }
        this.edges.remove(es);
        this.onEdgeRemoved(es);
    }

    @Override
    protected void add(Edge<N, E> es) {
        if (es == null) {
            throw new IllegalArgumentException("es == null");
        }
        this.edges.add(es);
        this.onEdgeAdded(es);
    }

    @Override
    public void add(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (!this.contains(node)) {
            this.nodes.add(node);
            this.onNodeAdded(node);
        }
    }

    @Override
    public void remove(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        Collection<Edge<N, Edge<N, E>>> list = this.factory.createEdgePairs();
        for (Edge<N, E> edge : this.edges) {
            if (!edge.getNodeA().equals(node) && !edge.getNodeB().equals(node)) continue;
            list.add(edge);
        }
        for (Edge<N, E> edge : list) {
            this.remove((N)edge);
        }
        N oldNode = null;
        for (N n : this.nodes) {
            if (!n.equals(node)) continue;
            oldNode = n;
        }
        if (oldNode != null) {
            this.nodes.remove(oldNode);
            this.onNodeRemoved(oldNode);
        }
    }

    @Override
    public void clearEdges() {
        for (Edge<N, E> e : this.edges) {
            this.remove((N)e);
        }
    }

    @Override
    public void clearAll() {
        for (Edge<N, E> e : this.edges) {
            this.remove((N)e);
        }
        for (Edge<N, E> n : this.nodes) {
            this.remove((N)n);
        }
    }

    @Override
    public void setEdge(N a, N b, E edge) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (edge == null) {
            throw new IllegalArgumentException("edge == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        ArrayList<E> l = new ArrayList<E>();
        l.add(edge);
        this.set(a, b, l);
    }

    @Override
    public void setEdges(N a, N b, Iterable<E> edges) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (edges == null) {
            throw new IllegalArgumentException("edges == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        this.set(a, b, edges);
    }

    @Override
    public void removeEdge(N a, N b) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Collection<Edge<N, Edge<N, E>>> oldEdgeslist = this.factory.createEdgePairs();
        for (Edge<N, E> edge : this.edges) {
            if (!edge.getNodeA().equals(a) || !edge.getNodeB().equals(b)) continue;
            oldEdgeslist.add(edge);
        }
        for (Edge<N, E> edge : oldEdgeslist) {
            this.remove((N)edge);
        }
    }
}

