/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.graph;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.Graph;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.iterators.TreeWalkItreator;
import xyz.cofe.collection.iterators.TreeWalkType;

public class GraphTools {
    private static final Logger logger = Logger.getLogger(GraphTools.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public static <N, E> Convertor<Edge<N, E>, N> nodeAOfEdge() {
        return new Convertor<Edge<N, E>, N>(){

            @Override
            public N convert(Edge<N, E> from) {
                if (from == null) {
                    return null;
                }
                return from.getNodeA();
            }
        };
    }

    public static <N, E> Convertor<Edge<N, E>, N> nodeBOfEdge() {
        return new Convertor<Edge<N, E>, N>(){

            @Override
            public N convert(Edge<N, E> from) {
                if (from == null) {
                    return null;
                }
                return from.getNodeB();
            }
        };
    }

    public static <N, E> NodesExtracter<N, N> nodeExtracter(final Graph<N, E> g, final Path.Direction direct) {
        if (g == null) {
            throw new IllegalArgumentException("g==null");
        }
        if (direct == null) {
            throw new IllegalArgumentException("direct==null");
        }
        Convertor<Edge<N, E>, N> conv = null;
        switch (direct) {
            case AB: {
                conv = GraphTools.nodeBOfEdge();
                break;
            }
            default: {
                conv = GraphTools.nodeAOfEdge();
            }
        }
        final Convertor<Edge<N, E>, N> cnv = conv;
        return new NodesExtracter<N, N>(){

            @Override
            public Iterable<N> extract(N from) {
                if (from == null) {
                    return Iterators.empty();
                }
                Iterable edges = null;
                switch (direct) {
                    case AB: {
                        edges = g.edgesOfNodeA(from);
                        break;
                    }
                    default: {
                        edges = g.edgesOfNodeB(from);
                    }
                }
                if (edges == null) {
                    return Iterators.empty();
                }
                Iterable res = Iterators.convert(edges, cnv);
                return res;
            }
        };
    }

    public static <N, E> int getMaxPathLength(Graph<N, E> g, N start, Path.Direction direct) {
        if (g == null) {
            throw new IllegalArgumentException("g==null");
        }
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (direct == null) {
            throw new IllegalArgumentException("direct==null");
        }
        NodesExtracter<N, N> walker = GraphTools.nodeExtracter(g, direct);
        Iterable<TreeWalk<N>> twIter = TreeWalkItreator.createIterable(start, walker, TreeWalkType.ByLevel);
        LinkedHashSet<N> visitedNodes = new LinkedHashSet<N>();
        int maxLevel = 0;
        for (TreeWalk<N> tw : twIter) {
            N n = tw.currentNode();
            if (visitedNodes.contains(n)) {
                return -1;
            }
            visitedNodes.add(n);
            int level = Math.abs(tw.currentLevel() - tw.startLevel());
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

