/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.graph;

import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.Path;

public abstract class AbstractPath<N, E>
implements Path<N, E> {
    protected Path.Direction direction = Path.Direction.AB;

    @Override
    public Edge<N, E> getLastEdge() {
        int size = this.size();
        if (size < 1) {
            return null;
        }
        return (Edge)this.get(size - 1);
    }

    @Override
    public N getLastNode() {
        Edge<N, E> e = this.getLastEdge();
        Path.Direction d = this.getDirection();
        if (e == null) {
            return null;
        }
        return d == null ? e.getNodeB() : (d.equals((Object)Path.Direction.AB) ? e.getNodeB() : e.getNodeA());
    }

    public void setDirection(Path.Direction d) {
        if (d == null) {
            throw new IllegalArgumentException("d==null");
        }
        this.direction = d;
    }

    @Override
    public Path.Direction getDirection() {
        return this.direction;
    }

    @Override
    public boolean contains(N a, N b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        for (Edge e : this) {
            if (!a.equals(e.getNodeA()) || !b.equals(e.getNodeB())) continue;
            return true;
        }
        return false;
    }
}

