/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.SortInsert;

public abstract class SortList<Container, Element>
extends SortInsert<Container, Element> {
    private static final Logger logger = Logger.getLogger(SortList.class.getName());
    protected long timeLimit = 0L;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = SortList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = SortList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = SortList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = SortList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = SortList.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = SortList.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(SortList.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(SortList.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void sort(Container cont, Comparator comp, int from, int toEx) {
        if (cont == null) {
            throw new IllegalArgumentException("cont==null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("comp==null");
        }
        if (from > toEx) {
            throw new IllegalArgumentException("from(" + from + ") > toEx(" + toEx + ")");
        }
        int sortSize = toEx - from;
        if (sortSize <= 1) {
            return;
        }
        long tlimit = this.timeLimit;
        int sfrom = from;
        int sto = from + 1;
        long t0 = System.currentTimeMillis();
        for (int elIdx = from + 1; !(elIdx >= toEx || Thread.interrupted() || tlimit > 0L && System.currentTimeMillis() - t0 >= tlimit); ++elIdx) {
            Element el = this.remove(cont, elIdx);
            if (el == null) {
                this.insert(cont, from, el);
                ++sfrom;
                ++sto;
                continue;
            }
            this.sortInsert(cont, el, comp, sfrom, sto);
            ++sto;
        }
    }

    public abstract Element remove(Container var1, int var2);

    public static SortList<List, Object> createForList() {
        return new SortList<List, Object>(){

            @Override
            public void insert(List container, int position, Object item) {
                container.add(position, item);
            }

            @Override
            public Object get(List container, int position) {
                return container.get(position);
            }

            @Override
            public Object remove(List cont, int index) {
                return cont.remove(index);
            }
        };
    }
}

