/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SortInsert<Container, Element> {
    private static final Logger logger = Logger.getLogger(SortInsert.class.getName());

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = SortInsert.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = SortInsert.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = SortInsert.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = SortInsert.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = SortInsert.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = SortInsert.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(SortInsert.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(SortInsert.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public abstract void insert(Container var1, int var2, Element var3);

    public abstract Element get(Container var1, int var2);

    public int sortInsert(Container container, Element item, Comparator comp, int begin, int endex) {
        if (container == null) {
            throw new IllegalArgumentException("container==null");
        }
        int rangeSize = endex - begin;
        if (rangeSize <= 0) {
            this.insert(container, begin, item);
            return begin;
        }
        int result = Integer.MIN_VALUE;
        if (rangeSize == 1) {
            Element it = this.get(container, begin);
            int cmp = comp.compare(item, it);
            if (cmp < 0) {
                this.insert(container, begin, item);
                return begin;
            }
            this.insert(container, begin + 1, item);
            return begin + 1;
        }
        int leftPartSize = rangeSize / 2;
        int rightPartSize = rangeSize - leftPartSize;
        int leftBegin = begin;
        int leftEndEx = begin + leftPartSize;
        int rightBegin = begin + leftPartSize;
        int rightEndEx = rightBegin + rightPartSize;
        if (leftPartSize < 1 && rightPartSize < 1) {
            throw new Error("error!");
        }
        if (leftPartSize < 1 && rightPartSize >= 1) {
            throw new Error("error!");
        }
        if (leftPartSize >= 1 && rightPartSize >= 1) {
            Element it0 = this.get(container, rightBegin);
            int cmp = comp.compare(item, it0);
            if (cmp < 0) {
                result = this.sortInsert(container, item, comp, leftBegin, leftEndEx);
                return result;
            }
            if (cmp == 0) {
                this.insert(container, rightBegin, item);
                return rightBegin;
            }
            if (cmp > 0) {
                result = this.sortInsert(container, item, comp, rightBegin, rightEndEx);
                return result;
            }
        } else if (leftPartSize >= 1 && rightPartSize < 1) {
            throw new Error("error!");
        }
        return result;
    }

    public static SortInsert<List, Object> createForList() {
        return new SortInsert<List, Object>(){

            @Override
            public void insert(List container, int position, Object item) {
                container.add(position, item);
            }

            @Override
            public Object get(List container, int position) {
                return container.get(position);
            }
        };
    }
}

