/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import xyz.cofe.cbuffer.page.PageError;
import xyz.cofe.cbuffer.page.Paged;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Tuple2;

public class MemFlatPaged
implements Paged,
ResizablePages {
    private volatile int pageSize;
    private volatile byte[] buffer;
    private volatile int dataSize;
    private volatile int maxPages = -1;
    protected volatile MemInfoUsed memInfo = new MemInfoUsed();
    private static final byte[] empty_bytes = new byte[0];
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public MemFlatPaged(int pageSize, int capacity, byte[] buffer, int dataSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize<1");
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity<1");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize<0");
        }
        if (dataSize > capacity) {
            throw new IllegalArgumentException("dataSize>capacity");
        }
        if (buffer != null) {
            if (buffer.length != capacity) {
                throw new IllegalArgumentException("buffer.length!=capacity");
            }
            this.buffer = buffer;
            this.pageSize = pageSize;
            this.dataSize = dataSize;
        } else {
            this.buffer = new byte[capacity];
            this.pageSize = pageSize;
            this.dataSize = 0;
        }
    }

    public MemFlatPaged(int pageSize, int capacity) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize<1");
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity<1");
        }
        this.buffer = new byte[capacity];
        this.pageSize = pageSize;
        this.dataSize = capacity;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    private static String toString(UsedPagesInfo m) {
        return "UsedPagesInfo { pageSize=" + m.pageSize() + " pageCount=" + m.pageCount() + " lastPageSize=" + m.lastPageSize() + " }";
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        return this.memInfo;
    }

    @Override
    public byte[] readPage(int page) {
        return this.readLock(() -> {
            this.buffer = this.buffer;
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            int off = page * this.pageSize;
            if (off >= this.dataSize) {
                return empty_bytes;
            }
            int tailSize = this.dataSize - off;
            int readSize = Math.min(tailSize, this.pageSize);
            byte[] buf = new byte[readSize];
            for (int i = 0; i < readSize; ++i) {
                buf[i] = this.buffer[off + i];
            }
            return buf;
        });
    }

    @Override
    public void writePage(int page, byte[] data) {
        this.readLock(() -> {
            this.buffer = this.buffer;
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (data == null) {
                throw new IllegalArgumentException("data==null");
            }
            if (data.length > this.pageSize) {
                throw new IllegalArgumentException("data.length>pageSize");
            }
            if (data.length < 1) {
                return;
            }
            int off = page * this.pageSize;
            int avail = this.buffer.length - off;
            if (avail <= 0) {
                throw new PageError("out of range");
            }
            if (avail < data.length) {
                throw new PageError("out of range");
            }
            byte[] newBuff = Arrays.copyOf(this.buffer, this.buffer.length);
            for (int i = 0; i < data.length; ++i) {
                newBuff[off + i] = data[i];
            }
            int end = off + data.length;
            if (end > this.dataSize) {
                this.dataSize = end;
            }
            this.buffer = this.buffer = newBuff;
        });
    }

    private Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of((Object)this.memInfo, (Object)this.memInfo);
        }
        UsedPagesInfo beforeChange = this.memInfo.clone();
        long currentPages = this.memoryInfo().pageCount();
        long nextPages = currentPages + (long)pages;
        long nextSize = nextPages * (long)this.pageSize;
        if (nextSize > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("can't extend, limit by Integer.MAX_VALUE");
        }
        if (this.maxPages > 0 && nextPages > (long)this.maxPages) {
            throw new OutOfMemoryError("can't extend, limit by maxPages");
        }
        this.buffer = Arrays.copyOf(this.buffer, (int)nextSize);
        this.dataSize = (int)nextSize;
        return Tuple2.of((Object)beforeChange, (Object)this.memInfo);
    }

    private Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        UsedPagesInfo beforeChange = this.memInfo.clone();
        long currentPages = this.memoryInfo().pageCount();
        long nextPages = currentPages - (long)pages;
        if (nextPages < 0L) {
            throw new PageError("can't reduce to negative size");
        }
        long nextSize = nextPages * (long)this.pageSize;
        this.buffer = Arrays.copyOf(this.buffer, (int)nextSize);
        this.dataSize = (int)nextSize;
        return Tuple2.of((Object)beforeChange, (Object)this.memInfo);
    }

    @Override
    public ResizablePages.ResizedPages resizePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        return this.writeLock(() -> {
            if (pages == 0) {
                UsedPagesInfo before = this.memoryInfo().clone();
                this.buffer = empty_bytes;
                this.dataSize = 0;
                return new ResizablePages.ResizedPages(before, this.memoryInfo().clone());
            }
            long nxtPageCnt = pages;
            long curPageCnt = this.memoryInfo().pageCount();
            long diffPgeCnt = nxtPageCnt - curPageCnt;
            if (diffPgeCnt > 0L) {
                if (diffPgeCnt > Integer.MAX_VALUE) {
                    throw new PageError("can't extend over " + diffPgeCnt + ", Integer.MAX_VALUE");
                }
                Tuple2<UsedPagesInfo, UsedPagesInfo> ext = this.extendPages((int)diffPgeCnt);
                return new ResizablePages.ResizedPages((UsedPagesInfo)ext.a(), (UsedPagesInfo)ext.b());
            }
            long abs_diff = -diffPgeCnt;
            if (abs_diff > Integer.MAX_VALUE) {
                throw new PageError("can't reduce over " + abs_diff + ", Integer.MAX_VALUE");
            }
            Tuple2<UsedPagesInfo, UsedPagesInfo> red = this.reducePages((int)abs_diff);
            return new ResizablePages.ResizedPages((UsedPagesInfo)red.a(), (UsedPagesInfo)red.b());
        });
    }

    public <R> R readLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void readLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.readLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public <R> R writeLock(Supplier<R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            R r = code.get();
            return r;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void writeLock(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        try {
            this.readWriteLock.writeLock().lock();
            code.run();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected static class MemInfoUsedClone
    implements UsedPagesInfo {
        protected volatile int pageCount;
        protected volatile int pageSize;
        protected volatile int lastPageSize;

        public MemInfoUsedClone(int pageCount, int pageSize, int lastPageSize) {
            this.pageCount = pageCount;
            this.pageSize = pageSize;
            this.lastPageSize = lastPageSize;
        }

        public MemInfoUsedClone(MemInfoUsedClone sample) {
            if (sample == null) {
                throw new IllegalArgumentException("sample==null");
            }
            this.pageCount = sample.pageCount;
            this.pageSize = sample.pageSize;
            this.lastPageSize = sample.lastPageSize;
        }

        public MemInfoUsedClone(MemInfoUsed sample) {
            if (sample == null) {
                throw new IllegalArgumentException("sample==null");
            }
            this.pageCount = sample.pageCount();
            this.pageSize = sample.pageSize();
            this.lastPageSize = sample.lastPageSize();
        }

        @Override
        public int pageCount() {
            return this.pageCount;
        }

        @Override
        public int lastPageSize() {
            return this.lastPageSize;
        }

        @Override
        public int pageSize() {
            return this.pageSize;
        }

        @Override
        public UsedPagesInfo clone() {
            return new MemInfoUsedClone(this);
        }

        public String toString() {
            return MemFlatPaged.toString(this);
        }
    }

    public class MemInfoUsed
    implements UsedPagesInfo {
        @Override
        public int pageCount() {
            return MemFlatPaged.this.readLock(() -> {
                int pc = MemFlatPaged.this.dataSize / MemFlatPaged.this.pageSize;
                int pc_d = MemFlatPaged.this.dataSize % MemFlatPaged.this.pageSize;
                return pc_d > 0 ? pc + 1 : pc;
            });
        }

        @Override
        public int lastPageSize() {
            return MemFlatPaged.this.readLock(() -> {
                int size = MemFlatPaged.this.dataSize % MemFlatPaged.this.pageSize;
                return size == 0 ? MemFlatPaged.this.pageSize : size;
            });
        }

        @Override
        public int pageSize() {
            return MemFlatPaged.this.readLock(() -> MemFlatPaged.this.pageSize);
        }

        @Override
        public UsedPagesInfo clone() {
            return MemFlatPaged.this.readLock(() -> new MemInfoUsedClone(this));
        }

        public String toString() {
            return MemFlatPaged.this.readLock(() -> MemFlatPaged.toString(this));
        }
    }
}

