/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import xyz.cofe.cbuffer.page.Paged;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;

public class MemChunkPaged
implements Paged,
ResizablePages {
    protected final int pageSize;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public volatile Chunk[] chunks = new Chunk[0];

    public MemChunkPaged(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        try {
            this.rwLock.readLock().lock();
            UsedPagesInfo usedPagesInfo = UsedPagesInfo.of(this.pageSize, this.chunks.length, this.chunks.length > 0 ? this.chunks[this.chunks.length - 1].size() : 0);
            return usedPagesInfo;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResizablePages.ResizedPages resizePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        try {
            this.rwLock.writeLock().lock();
            int adds = pages - this.chunks.length;
            Chunk[] newChunks = Arrays.copyOf(this.chunks, pages);
            if (adds > 0) {
                int from = this.chunks.length;
                for (int i = 0; i < adds; ++i) {
                    newChunks[from + i] = new Chunk(this.pageSize);
                }
            }
            this.chunks = newChunks;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] readPage(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        try {
            Chunk ch;
            this.rwLock.readLock().lock();
            if (page >= this.chunks.length) {
                throw new IllegalArgumentException("page>=chunks.length");
            }
            Chunk chunk = ch = this.chunks[page];
            synchronized (chunk) {
                byte[] byArray = this.chunks[page].read();
                return byArray;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writePage(int page, byte[] data) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        try {
            Chunk ch;
            this.rwLock.readLock().lock();
            if (page >= this.chunks.length) {
                throw new IllegalArgumentException("page>=chunks.length");
            }
            byte[] writeData = data.length != page ? Arrays.copyOf(data, this.pageSize) : data;
            Chunk chunk = ch = this.chunks[page];
            synchronized (chunk) {
                this.chunks[page].write(writeData);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public static class Chunk {
        public volatile byte[] data;
        public volatile int firstInt;

        public Chunk(int pageSize) {
            this.data = new byte[pageSize];
        }

        public static int readInt(byte[] data, int offset) {
            int b0 = data[offset + 3] & 0xFF;
            int b1 = data[offset + 2] & 0xFF;
            int b2 = data[offset + 1] & 0xFF;
            int b3 = data[offset + 0] & 0xFF;
            return b3 << 24 | b2 << 16 | b1 << 8 | b0;
        }

        public static void writeInt(byte[] data, int offset, int value) {
            int b0 = value >> 24 & 0xFF;
            int b1 = value >> 16 & 0xFF;
            int b2 = value >> 8 & 0xFF;
            int b3 = value >> 0 & 0xFF;
            data[offset + 0] = (byte)b0;
            data[offset + 1] = (byte)b1;
            data[offset + 2] = (byte)b2;
            data[offset + 3] = (byte)b3;
        }

        public synchronized byte[] read() {
            this.data = this.data;
            byte[] res = new byte[this.data.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.data[i];
            }
            return res;
        }

        public synchronized void write(byte[] newData) {
            this.data = this.data;
            if (this.data.length != newData.length) {
                throw new IllegalStateException("!!!");
            }
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = newData[i];
            }
            this.firstInt = Chunk.readInt(this.data, 0);
            this.data = this.data;
        }

        public synchronized int size() {
            return this.data.length;
        }
    }
}

