/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.page.CachePaged;
import xyz.cofe.cbuffer.page.Paged;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;

public class CachePagesBuffer<CACHEPAGES extends Paged & ResizablePages, PERSISTPAGES extends Paged & ResizablePages>
implements ContentBuffer {
    private final CachePaged<CACHEPAGES, PERSISTPAGES> pages;

    public CachePagesBuffer(CachePaged<CACHEPAGES, PERSISTPAGES> pages) {
        if (pages == null) {
            throw new IllegalArgumentException("cachePaged==null");
        }
        this.pages = pages;
    }

    public CachePaged<CACHEPAGES, PERSISTPAGES> getPages() {
        return this.pages;
    }

    @Override
    public long getSize() {
        UsedPagesInfo memInfo = this.getPages().memoryInfo();
        return memInfo.pageCount() == 0 ? 0L : (long)(memInfo.pageCount() - 1) * (long)memInfo.pageSize() + (long)memInfo.lastPageSize();
    }

    @Override
    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size<0");
        }
        if (size == 0L) {
            this.pages.resizeCachePages(0);
            this.pages.resizePages(0);
            return;
        }
        UsedPagesInfo memInfo = this.getPages().memoryInfo();
        long pc_rest = size % (long)memInfo.pageSize();
        long pc = size / (long)memInfo.pageSize() + (long)(pc_rest > 0L ? 1 : 0);
        if (pc > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow pages count, over Integer.MAX_VALUE");
        }
        this.getPages().resizePages((int)pc);
    }

    @Override
    public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset<0");
        }
        if (data.length < dataOffset + dataLen) {
            throw new IllegalArgumentException("data.length(=" + data.length + ") < (dataOffset(=" + dataOffset + ")+dataLen(=" + dataLen + "))");
        }
        if (dataLen == 0) {
            return;
        }
        int page_size = this.pages.memoryInfo().pageSize();
        if (page_size < 1) {
            throw new IllegalStateException("pageSize(=" + page_size + ") to small, must be 1 or greater");
        }
        long page_from = offset / (long)page_size;
        if (page_from > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + page_from + ") > Integer.MAX_VALUE");
        }
        long page_to = (offset + (long)dataLen) / (long)page_size + 1L;
        if (page_to > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + page_to + ") > Integer.MAX_VALUE");
        }
        Runnable write = () -> {
            int write_size;
            int page = (int)page_from;
            int page_off = (int)(offset % (long)page_size);
            byte[] page_buff = new byte[page_size];
            for (int writed = 0; writed < dataLen; writed += write_size) {
                int page_av = page_size - page_off;
                int avail = dataLen - writed;
                write_size = Math.min(avail, page_av);
                if (page_off > 0 || write_size != page_size) {
                    byte[] page_data = this.pages.readPage(page);
                    if (page_data.length < page_size) {
                        page_data = Arrays.copyOf(page_data, page_size);
                    }
                    System.arraycopy(data, writed + dataOffset, page_data, page_off, write_size);
                    this.pages.writePage(page, page_data);
                } else {
                    System.arraycopy(data, writed + dataOffset, page_buff, 0, page_size);
                    this.pages.writePage(page, page_buff);
                }
                page_off = 0;
                ++page;
            }
        };
        this.pages.writePersistentLock((int)page_from, (int)page_to, write);
    }

    @Override
    public byte[] get(long offset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        if (dataLen == 0) {
            return new byte[0];
        }
        long total_bytes_count = this.getSize();
        if (offset >= total_bytes_count) {
            return new byte[0];
        }
        int pageSize = this.pages.memoryInfo().pageSize();
        if (pageSize < 1) {
            throw new IllegalStateException("pageSize(=" + pageSize + ") to small, must be 1 or greater");
        }
        long pageFrom = offset / (long)pageSize;
        if (pageFrom > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + pageFrom + ") > Integer.MAX_VALUE");
        }
        long pageTo = (offset + (long)dataLen) / (long)pageSize + 1L;
        if (pageTo > Integer.MAX_VALUE) {
            throw new IllegalStateException("can't write page(=" + pageTo + ") > Integer.MAX_VALUE");
        }
        int initialPageOffset = (int)(offset % (long)pageSize);
        return this.pages.readPersistentLock((int)pageFrom, (int)pageTo, () -> {
            byte[] bytes;
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            int page = (int)pageFrom;
            int off = initialPageOffset;
            while (ba.size() < dataLen && off < (bytes = this.pages.readPage(page)).length) {
                int avail = bytes.length - off;
                int rest = dataLen - ba.size();
                int readSize = Math.min(rest, avail);
                ba.write(bytes, off, readSize);
                ++page;
                off = 0;
            }
            return ba.toByteArray();
        });
    }

    @Override
    public void clear() {
        this.setSize(0L);
    }

    @Override
    public void flush() {
        this.pages.flush();
    }

    @Override
    public void close() {
    }
}

