/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Objects;
import xyz.cofe.cbuffer.page.Distance;
import xyz.cofe.cbuffer.page.NanoDuration;

public class NanoTime
implements Comparable<NanoTime>,
Distance<NanoTime, NanoDuration> {
    public final long time;

    public NanoTime() {
        this.time = System.nanoTime();
    }

    public NanoTime(long t) {
        this.time = t;
    }

    public NanoTime(NanoTime sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.time = sample.time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NanoTime nanoTime = (NanoTime)o;
        return this.time == nanoTime.time;
    }

    public int hashCode() {
        return Objects.hash(this.time);
    }

    @Override
    public int compareTo(NanoTime o) {
        if (o == null) {
            return 0;
        }
        return Long.compare(this.time, o.time);
    }

    @Override
    public NanoDuration distance(NanoTime a) {
        if (a == null) {
            return null;
        }
        return new NanoDuration(this.time - a.time);
    }
}

