/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.math.BigInteger;
import java.util.Arrays;
import xyz.cofe.cbuffer.page.Capacity;
import xyz.cofe.cbuffer.page.ExtendablePages;
import xyz.cofe.cbuffer.page.PagedData;
import xyz.cofe.cbuffer.page.ReduciblePages;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Tuple2;

public class MemPagedData
implements PagedData<UsedPagesInfo>,
ExtendablePages<UsedPagesInfo>,
ReduciblePages<UsedPagesInfo>,
ResizablePages<UsedPagesInfo> {
    protected int pageSize;
    protected byte[] buffer;
    protected int dataSize;
    protected int maxPages = -1;
    protected MemInfoUsed memInfo = new MemInfoUsed();
    private static final byte[] empty_bytes = new byte[0];

    public MemPagedData(int pageSize, int capacity, byte[] buffer, int dataSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize<1");
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity<1");
        }
        int ext = capacity % pageSize;
        if (ext > 0) {
            throw new IllegalArgumentException("capacity(=" + capacity + ") not align by pageSize(=" + pageSize + "); capacity % pageSize = " + ext + " > 0");
        }
        if (dataSize < 0) {
            throw new IllegalArgumentException("dataSize<0");
        }
        if (dataSize > capacity) {
            throw new IllegalArgumentException("dataSize>capacity");
        }
        if (buffer != null) {
            if (buffer.length != capacity) {
                throw new IllegalArgumentException("buffer.length!=capacity");
            }
            this.buffer = buffer;
            this.pageSize = pageSize;
            this.dataSize = dataSize;
        } else {
            this.buffer = new byte[capacity];
            this.pageSize = pageSize;
            this.dataSize = 0;
        }
    }

    public MemPagedData(int pageSize, int capacity) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize<1");
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity<1");
        }
        int ext = capacity % pageSize;
        if (ext > 0) {
            throw new IllegalArgumentException("capacity(=" + capacity + ") not align by pageSize(=" + pageSize + "); capacity % pageSize = " + ext + " > 0");
        }
        this.buffer = new byte[capacity];
        this.pageSize = pageSize;
        this.dataSize = 0;
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        return this.memInfo;
    }

    @Override
    public byte[] readPage(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        int off = page * this.pageSize;
        if (off >= this.dataSize) {
            return empty_bytes;
        }
        int tailSize = this.dataSize - off;
        int readSize = Math.min(tailSize, this.pageSize);
        byte[] buf = new byte[readSize];
        System.arraycopy(this.buffer, off, buf, 0, readSize);
        return buf;
    }

    @Override
    public void writePage(int page, byte[] data) {
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (data.length > this.pageSize) {
            throw new IllegalArgumentException("data.length>pageSize");
        }
        if (data.length < 1) {
            return;
        }
        int off = page * this.pageSize;
        int avail = this.buffer.length - off;
        if (avail <= 0) {
            throw new IllegalArgumentException("out of range");
        }
        if (avail < data.length) {
            throw new IllegalArgumentException("out of range");
        }
        System.arraycopy(data, 0, this.buffer, off, data.length);
        int end = off + data.length;
        if (end > this.dataSize) {
            this.dataSize = end;
        }
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of((Object)this.memInfo, (Object)this.memInfo);
        }
        UsedPagesInfo beforeChange = this.memInfo.clone();
        long currentPages = this.memoryInfo().pageCount();
        long nextPages = currentPages + (long)pages;
        long nextSize = nextPages * (long)this.pageSize;
        if (nextSize > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("can't extend, limit by Integer.MAX_VALUE");
        }
        if (this.maxPages > 0 && nextPages > (long)this.maxPages) {
            throw new OutOfMemoryError("can't extend, limit by maxPages");
        }
        this.buffer = Arrays.copyOf(this.buffer, (int)nextSize);
        this.dataSize = (int)nextSize;
        return Tuple2.of((Object)beforeChange, (Object)this.memInfo);
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("pages<0");
        }
        if (pages == 0) {
            return Tuple2.of((Object)this.memInfo, (Object)this.memInfo);
        }
        UsedPagesInfo beforeChange = this.memInfo.clone();
        long currentPages = this.memoryInfo().pageCount();
        long nextPages = currentPages - (long)pages;
        if (nextPages < 0L) {
            throw new IllegalArgumentException("can't reduce to negative size");
        }
        long nextSize = nextPages * (long)this.pageSize;
        this.buffer = Arrays.copyOf(this.buffer, (int)nextSize);
        this.dataSize = (int)nextSize;
        return Tuple2.of((Object)beforeChange, (Object)this.memInfo);
    }

    protected static class MemInfoUsedClone
    implements UsedPagesInfo,
    Capacity {
        protected BigInteger capacity;
        protected int pageCount;
        protected int pageSize;
        protected int lastPageSize;

        public MemInfoUsedClone(BigInteger capacity, int pageCount, int pageSize, int lastPageSize) {
            this.capacity = capacity;
            this.pageCount = pageCount;
            this.pageSize = pageSize;
            this.lastPageSize = lastPageSize;
        }

        public MemInfoUsedClone(MemInfoUsedClone sample) {
            if (sample == null) {
                throw new IllegalArgumentException("sample==null");
            }
            this.capacity = sample.capacity;
            this.pageCount = sample.pageCount;
            this.pageSize = sample.pageSize;
            this.lastPageSize = sample.lastPageSize;
        }

        public MemInfoUsedClone(MemInfoUsed sample) {
            if (sample == null) {
                throw new IllegalArgumentException("sample==null");
            }
            this.capacity = sample.capacity();
            this.pageCount = sample.pageCount();
            this.pageSize = sample.pageSize();
            this.lastPageSize = sample.lastPageSize();
        }

        @Override
        public BigInteger capacity() {
            return this.capacity;
        }

        @Override
        public int pageCount() {
            return this.pageCount;
        }

        @Override
        public int lastPageSize() {
            return this.lastPageSize;
        }

        @Override
        public int pageSize() {
            return this.pageSize;
        }

        @Override
        public UsedPagesInfo clone() {
            return new MemInfoUsedClone(this);
        }
    }

    protected class MemInfoUsed
    implements UsedPagesInfo,
    Capacity {
        protected MemInfoUsed() {
        }

        @Override
        public int pageCount() {
            int pc = MemPagedData.this.dataSize / MemPagedData.this.pageSize;
            int pc_d = MemPagedData.this.dataSize % MemPagedData.this.pageSize;
            return pc_d > 0 ? pc + 1 : pc;
        }

        @Override
        public int lastPageSize() {
            return MemPagedData.this.dataSize % MemPagedData.this.pageSize;
        }

        @Override
        public int pageSize() {
            return MemPagedData.this.pageSize;
        }

        @Override
        public BigInteger capacity() {
            return BigInteger.valueOf(MemPagedData.this.buffer.length);
        }

        @Override
        public UsedPagesInfo clone() {
            return new MemInfoUsedClone(this);
        }
    }
}

