/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;

public interface DirtyPagedState {
    public int pageCount();

    public Optional<PageState> page(int var1);

    public void flushed(int var1, long var2);

    public void written(int var1, long var2);

    public void read(int var1, long var2);

    public void resizePages(int var1);

    public void each(Consumer<PageState> var1);

    public static class VolatileState
    implements DirtyPagedState {
        protected volatile long[] flushTime = new long[0];
        protected volatile long[] writeTime = new long[0];
        protected volatile long[] readTime = new long[0];

        @Override
        public int pageCount() {
            long[] pages = this.flushTime;
            return pages != null ? pages.length : 0;
        }

        @Override
        public Optional<PageState> page(int page) {
            long[] flush_t = this.flushTime;
            long[] write_t = this.writeTime;
            long[] read_t = this.readTime;
            if (flush_t == null || write_t == null || read_t == null) {
                return Optional.empty();
            }
            if (flush_t.length != write_t.length || write_t.length != read_t.length) {
                return Optional.empty();
            }
            if (page >= flush_t.length || page < 0) {
                return Optional.empty();
            }
            return Optional.of(PageState.create(page, read_t[page], write_t[page], flush_t[page]));
        }

        @Override
        public void each(Consumer<PageState> pageState) {
            if (pageState == null) {
                throw new IllegalArgumentException("pageState==null");
            }
            long[] flush = this.flushTime;
            long[] write = this.writeTime;
            long[] read = this.readTime;
            if (flush == null || write == null || read == null) {
                return;
            }
            if (flush.length != write.length || write.length != read.length) {
                return;
            }
            for (int i = 0; i < flush.length; ++i) {
                pageState.accept(PageState.create(i, read[i], write[i], flush[i]));
            }
        }

        @Override
        public void flushed(int page, long time) {
            long[] flushTime = this.flushTime;
            if (flushTime == null) {
                throw new IllegalStateException("flushTime==null");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (page >= flushTime.length) {
                throw new IllegalArgumentException("page>=flushTime.length");
            }
            flushTime[page] = time;
        }

        @Override
        public void written(int page, long time) {
            long[] times = this.writeTime;
            if (times == null) {
                throw new IllegalStateException("writeTime==null");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (page >= times.length) {
                throw new IllegalArgumentException("page>=writeTime.length");
            }
            times[page] = time;
        }

        @Override
        public void read(int page, long time) {
            long[] times = this.readTime;
            if (times == null) {
                throw new IllegalStateException("readTime==null");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (page >= times.length) {
                throw new IllegalArgumentException("page>=readTime.length");
            }
            times[page] = time;
        }

        @Override
        public synchronized void resizePages(int pages) {
            if (pages < 0) {
                throw new IllegalArgumentException("pages<0");
            }
            long[] flushTime = this.flushTime;
            long[] writeTime = this.writeTime;
            long[] readTime = this.readTime;
            int before = flushTime != null ? flushTime.length : 0;
            int null_c = (flushTime == null ? 1 : 0) + (writeTime == null ? 1 : 0) + (readTime == null ? 1 : 0);
            if (null_c != 0 && null_c != 3) {
                throw new IllegalStateException("bug!! null ref (flushTime|writeTime|readTime) count not match 0|3");
            }
            if (flushTime != null && writeTime != null && readTime != null && (flushTime.length != readTime.length || readTime.length != writeTime.length)) {
                throw new IllegalStateException("bug! internal arrays length, not matched");
            }
            flushTime = flushTime != null ? Arrays.copyOf(flushTime, pages) : new long[pages];
            writeTime = writeTime != null ? Arrays.copyOf(writeTime, pages) : new long[pages];
            readTime = readTime != null ? Arrays.copyOf(readTime, pages) : new long[pages];
            int extCnt = pages - before;
            if (extCnt > 0) {
                for (int i = before; i < pages; ++i) {
                    flushTime[i] = 0L;
                    writeTime[i] = 0L;
                    readTime[i] = 0L;
                }
            }
            this.flushTime = flushTime;
            this.writeTime = writeTime;
            this.readTime = readTime;
        }
    }

    public static class NonThreadSafe
    implements DirtyPagedState {
        protected long[] flushTime = new long[0];
        protected long[] writeTime = new long[0];
        protected long[] readTime = new long[0];

        @Override
        public int pageCount() {
            long[] pages = this.flushTime;
            return pages != null ? pages.length : 0;
        }

        @Override
        public Optional<PageState> page(int page) {
            long[] flush_t = this.flushTime;
            long[] write_t = this.writeTime;
            long[] read_t = this.readTime;
            if (flush_t == null || write_t == null || read_t == null) {
                return Optional.empty();
            }
            if (flush_t.length != write_t.length || write_t.length != read_t.length) {
                return Optional.empty();
            }
            if (page >= flush_t.length || page < 0) {
                return Optional.empty();
            }
            return Optional.of(PageState.create(page, read_t[page], write_t[page], flush_t[page]));
        }

        @Override
        public void each(Consumer<PageState> pageState) {
            if (pageState == null) {
                throw new IllegalArgumentException("pageState==null");
            }
            long[] flush = this.flushTime;
            long[] write = this.writeTime;
            long[] read = this.readTime;
            if (flush == null || write == null || read == null) {
                return;
            }
            if (flush.length != write.length || write.length != read.length) {
                return;
            }
            for (int i = 0; i < flush.length; ++i) {
                pageState.accept(PageState.create(i, read[i], write[i], flush[i]));
            }
        }

        @Override
        public void flushed(int page, long time) {
            long[] flushTime = this.flushTime;
            if (flushTime == null) {
                throw new IllegalStateException("flushTime==null");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (page >= flushTime.length) {
                throw new IllegalArgumentException("page>=flushTime.length");
            }
            flushTime[page] = time;
        }

        @Override
        public void written(int page, long time) {
            long[] times = this.writeTime;
            if (times == null) {
                throw new IllegalStateException("writeTime==null");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (page >= times.length) {
                throw new IllegalArgumentException("page>=writeTime.length");
            }
            times[page] = time;
        }

        @Override
        public void read(int page, long time) {
            long[] times = this.readTime;
            if (times == null) {
                throw new IllegalStateException("readTime==null");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            if (page >= times.length) {
                throw new IllegalArgumentException("page>=readTime.length");
            }
            times[page] = time;
        }

        @Override
        public void resizePages(int pages) {
            if (pages < 0) {
                throw new IllegalArgumentException("pages<0");
            }
            long[] flushTime = this.flushTime;
            long[] writeTime = this.writeTime;
            long[] readTime = this.readTime;
            int before = flushTime != null ? flushTime.length : 0;
            int null_c = (flushTime == null ? 1 : 0) + (writeTime == null ? 1 : 0) + (readTime == null ? 1 : 0);
            if (null_c != 0 && null_c != 3) {
                throw new IllegalStateException("bug!! null ref (flushTime|writeTime|readTime) count not match 0|3");
            }
            if (flushTime != null && writeTime != null && readTime != null && (flushTime.length != readTime.length || readTime.length != writeTime.length)) {
                throw new IllegalStateException("bug! internal arrays length, not matched");
            }
            flushTime = flushTime != null ? Arrays.copyOf(flushTime, pages) : new long[pages];
            writeTime = writeTime != null ? Arrays.copyOf(writeTime, pages) : new long[pages];
            readTime = readTime != null ? Arrays.copyOf(readTime, pages) : new long[pages];
            int extCnt = pages - before;
            if (extCnt > 0) {
                for (int i = before; i < pages; ++i) {
                    flushTime[i] = 0L;
                    writeTime[i] = 0L;
                    readTime[i] = 0L;
                }
            }
            this.flushTime = flushTime;
            this.writeTime = writeTime;
            this.readTime = readTime;
        }
    }

    public static interface PageState {
        public int page();

        public long flushTime();

        public long writeTime();

        public long readTime();

        default public boolean dirty() {
            long wt;
            long ft = this.flushTime();
            return ft <= (wt = this.writeTime());
        }

        public static PageState create(final int page, final long readTime, final long writeTime, final long flushTime) {
            return new PageState(){

                @Override
                public int page() {
                    return page;
                }

                @Override
                public long flushTime() {
                    return flushTime;
                }

                @Override
                public long writeTime() {
                    return writeTime;
                }

                @Override
                public long readTime() {
                    return readTime;
                }
            };
        }
    }
}

