/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.page.DirtyPagedState;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Consumer1;
import xyz.cofe.fn.Tuple2;

public abstract class DirtyPagedDataBase<M extends UsedPagesInfo, S extends DirtyPagedState>
implements ResizablePages<M> {
    protected ResizablePages<M> pagedData;

    protected abstract S state();

    public DirtyPagedDataBase(ResizablePages<M> pagedData) {
        if (pagedData == null) {
            throw new IllegalArgumentException("pagedData==null");
        }
        this.pagedData = pagedData;
        this.state().resizePages(pagedData.memoryInfo().pageCount());
    }

    protected long now() {
        return System.nanoTime();
    }

    public void flushPage(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("page(=" + page + " <0) out of range");
        }
        this.state().flushed(page, this.now());
    }

    public boolean dirty(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("page(=" + page + " <0) out of range");
        }
        DirtyPagedState.PageState ps = this.state().page(page).orElseThrow(() -> new IllegalArgumentException("page=" + page + " not found"));
        return ps.dirty();
    }

    public void dirtyPages(Consumer1<Integer> dirtyPage) {
        if (dirtyPage == null) {
            throw new IllegalArgumentException("dirtyPage==null");
        }
        this.state().each(ps -> {
            if (ps.dirty()) {
                dirtyPage.accept((Object)ps.page());
            }
        });
    }

    @Override
    public M memoryInfo() {
        return (M)this.pagedData.memoryInfo();
    }

    @Override
    public byte[] readPage(int page) {
        byte[] data = this.pagedData.readPage(page);
        this.state().read(page, this.now());
        return data;
    }

    @Override
    public void writePage(int page, byte[] data) {
        this.pagedData.writePage(page, data);
        this.state().written(page, this.now());
    }

    protected void onChangeResizePages(Tuple2<UsedPagesInfo, UsedPagesInfo> changes) {
        if (changes == null) {
            throw new IllegalArgumentException("changes==null");
        }
        this.state().resizePages(((UsedPagesInfo)changes.b()).pageCount());
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        Tuple2<UsedPagesInfo, UsedPagesInfo> memChangeInfo = this.pagedData.extendPages(pages);
        this.onChangeResizePages(memChangeInfo);
        return memChangeInfo;
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        Tuple2<UsedPagesInfo, UsedPagesInfo> memChangeInfo = this.pagedData.reducePages(pages);
        this.onChangeResizePages(memChangeInfo);
        return memChangeInfo;
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> resizePages(int pages) {
        Tuple2<UsedPagesInfo, UsedPagesInfo> memChangeInfo = this.pagedData.resizePages(pages);
        this.onChangeResizePages(memChangeInfo);
        return memChangeInfo;
    }
}

