/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import xyz.cofe.cbuffer.page.DirtyPagedDataBase;
import xyz.cofe.cbuffer.page.DirtyPagedState;
import xyz.cofe.cbuffer.page.IntArrayMutable;
import xyz.cofe.cbuffer.page.IntArrayReadOnly;
import xyz.cofe.cbuffer.page.MapMutable;
import xyz.cofe.cbuffer.page.MapReadonly;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Tuple2;

public interface CachePagedState<M extends UsedPagesInfo, D extends DirtyPagedDataBase<M, ? extends DirtyPagedState>> {
    public D cachePages();

    public void cachePages(D var1);

    public ResizablePages<M> persistentPages();

    public void persistentPages(ResizablePages<M> var1);

    public <R> R cache2prst_read(Function<IntArrayReadOnly, R> var1);

    public void cache2prst_write(Consumer<IntArrayMutable> var1);

    public void cache2prst_replace(Function<IntArrayReadOnly, int[]> var1);

    public Map<Integer, Integer> prst2cache();

    default public <R> R prst2cache_read(Function<MapReadonly<Integer, Integer>, R> code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        Map<Integer, Integer> map = this.prst2cache();
        return code.apply(MapReadonly.of(map));
    }

    public void prst2cache(Map<Integer, Integer> var1);

    default public <R> R prst2cache_write(Function<MapMutable<Integer, Integer>, R> code) {
        Map<Integer, Integer> map = this.prst2cache();
        R r = code.apply(MapMutable.of(map));
        this.prst2cache(map);
        return r;
    }

    public boolean isClosed();

    public void close();

    public void statCacheHitMiss(boolean var1);

    public Tuple2<Long, Long> statCacheHitMiss();

    public static NonThreadSafe nonSafe() {
        return new NonThreadSafe();
    }

    public static class NonThreadSafe
    implements CachePagedState<UsedPagesInfo, DirtyPagedDataBase<UsedPagesInfo, DirtyPagedState.NonThreadSafe>> {
        private DirtyPagedDataBase<UsedPagesInfo, DirtyPagedState.NonThreadSafe> cachePages;
        private ResizablePages<UsedPagesInfo> persistentPages;
        private int[] cache2prst = new int[0];
        private Map<Integer, Integer> prst2cache = new HashMap<Integer, Integer>();
        private boolean closed = false;
        private long stateCacheHit = 0L;
        private long stateCacheMiss = 0L;

        @Override
        public void statCacheHitMiss(boolean hit) {
            if (hit) {
                ++this.stateCacheHit;
            } else {
                ++this.stateCacheMiss;
            }
        }

        @Override
        public Tuple2<Long, Long> statCacheHitMiss() {
            return Tuple2.of((Object)this.stateCacheHit, (Object)this.stateCacheMiss);
        }

        @Override
        public DirtyPagedDataBase<UsedPagesInfo, DirtyPagedState.NonThreadSafe> cachePages() {
            if (this.closed) {
                throw new IllegalStateException("CachePagedData closed");
            }
            return this.cachePages;
        }

        @Override
        public void cachePages(DirtyPagedDataBase<UsedPagesInfo, DirtyPagedState.NonThreadSafe> pages) {
            if (this.closed) {
                throw new IllegalStateException("CachePagedData closed");
            }
            this.cachePages = pages;
        }

        @Override
        public ResizablePages persistentPages() {
            if (this.closed) {
                throw new IllegalStateException("CachePagedData closed");
            }
            return this.persistentPages;
        }

        @Override
        public void persistentPages(ResizablePages pages) {
            if (this.closed) {
                throw new IllegalStateException("CachePagedData closed");
            }
            this.persistentPages = pages;
        }

        @Override
        public <R> R cache2prst_read(Function<IntArrayReadOnly, R> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            return code.apply(IntArrayReadOnly.of(this.cache2prst));
        }

        @Override
        public void cache2prst_write(Consumer<IntArrayMutable> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            code.accept(IntArrayMutable.of(this.cache2prst));
        }

        @Override
        public void cache2prst_replace(Function<IntArrayReadOnly, int[]> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            int[] res = code.apply(IntArrayReadOnly.of(this.cache2prst == null ? new int[]{} : this.cache2prst));
            if (res == null) {
                throw new IllegalStateException("cache2prst_replace(code), code - return null");
            }
            this.cache2prst = res;
        }

        @Override
        public Map<Integer, Integer> prst2cache() {
            if (this.closed) {
                throw new IllegalStateException("CachePagedData closed");
            }
            return this.prst2cache;
        }

        @Override
        public void prst2cache(Map<Integer, Integer> map) {
            if (this.closed) {
                throw new IllegalStateException("CachePagedData closed");
            }
            this.prst2cache = map;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            if (!this.closed) {
                if (this.persistentPages instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)this.persistentPages)).close();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
                this.persistentPages = null;
                if (this.cachePages instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)this.cachePages)).close();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
                this.cachePages = null;
                this.cache2prst = null;
                this.prst2cache = null;
            }
            this.closed = true;
        }
    }
}

