/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import xyz.cofe.cbuffer.page.CachePagedDataBase;
import xyz.cofe.cbuffer.page.CachePagedState;
import xyz.cofe.cbuffer.page.DirtyPagedDataSafe;
import xyz.cofe.cbuffer.page.IntArrayMutable;
import xyz.cofe.cbuffer.page.IntArrayReadOnly;
import xyz.cofe.cbuffer.page.PageLock;
import xyz.cofe.cbuffer.page.ResizablePages;
import xyz.cofe.cbuffer.page.UsedPagesInfo;
import xyz.cofe.fn.Consumer1;
import xyz.cofe.fn.Tuple2;

public class CCachePagedData
extends CachePagedDataBase<State, UsedPagesInfo, DirtyPagedDataSafe>
implements PageLock {
    protected final Object closeSync = new Object();

    protected CCachePagedData(State state) {
        super(state);
    }

    public CCachePagedData(DirtyPagedDataSafe cachePages, ResizablePages<UsedPagesInfo> persistentPages) {
        super(cachePages, persistentPages, new State());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isClosed() {
        Object object = this.closeSync;
        synchronized (object) {
            return super.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeSync;
        synchronized (object) {
            ((State)this.state).close();
        }
    }

    @Override
    public UsedPagesInfo memoryInfo() {
        return ((State)this.state).globalCacheLock(false, () -> super.memoryInfo());
    }

    @Override
    protected int persist2cache(int persistPage) {
        return ((State)this.state).globalCacheLock(false, () -> super.persist2cache(persistPage));
    }

    protected int persist2cache_mut(int persistPage) {
        return ((State)this.state).globalCacheLock(true, () -> super.persist2cache(persistPage));
    }

    @Override
    protected int cache2persist(int cachePage) {
        return ((State)this.state).globalCacheLock(false, () -> super.cache2persist(cachePage));
    }

    @Override
    protected int cache2persist_mut(int cachePage) {
        return ((State)this.state).globalCacheLock(true, () -> super.cache2persist_mut(cachePage));
    }

    @Override
    protected boolean dirty(int cachePage) {
        return ((State)this.state).globalCacheLock(false, () -> ((State)this.state).cachePageReadLock(cachePage, () -> super.dirty(cachePage)));
    }

    @Override
    protected boolean dirty_mut(int cachePage) {
        return ((State)this.state).globalCacheLock(true, () -> ((State)this.state).cachePageWriteLock(cachePage, () -> super.dirty(cachePage)));
    }

    @Override
    protected int flush(int cachePage) {
        return ((State)this.state).globalCacheLock(false, () -> ((State)this.state).cachePageReadLock(cachePage, () -> super.flush(cachePage)));
    }

    @Override
    protected int flush_mut(int cachePage) {
        return ((State)this.state).globalCacheLock(true, () -> ((State)this.state).cachePageWriteLock(cachePage, () -> super.flush_mut(cachePage)));
    }

    private LockAll lockAll() {
        List locked = ((State)this.state).cache2prst_read(arr -> {
            ArrayList<Lock> locks = new ArrayList<Lock>();
            for (int cache_page = 0; cache_page < arr.length(); ++cache_page) {
                Optional<ReadWriteLock> rwLock = ((State)this.state).cachePageRWLock(cache_page);
                if (!rwLock.isPresent()) continue;
                Lock lock = rwLock.get().readLock();
                lock.lock();
                locks.add(lock);
            }
            return locks;
        });
        return new LockAll(locked);
    }

    @Override
    public void flush() {
        ((State)this.state).globalCacheLock(false, () -> {
            LockAll lockAll = this.lockAll();
            try {
                if (this.isClosed()) {
                    throw new IllegalStateException("closed");
                }
                DirtyPagedDataSafe dirty = ((State)this.state).cachePages();
                if (dirty == null) {
                    throw new IllegalStateException("state.cachePages() is null");
                }
                dirty.dirtyPages((Consumer1<Integer>)(Consumer1 & Serializable)page -> this.flush0((int)page, false, false));
            }
            finally {
                lockAll.release();
            }
            return null;
        });
    }

    @Override
    protected int unmap(int cachePage) {
        if (cachePage < 0) {
            throw new IllegalArgumentException("cachePage<0");
        }
        return ((State)this.state).globalCacheLock(true, () -> ((State)this.state).cachePageWriteLock(cachePage, () -> super.unmap(cachePage)));
    }

    @Override
    protected Tuple2<List<Integer>, List<Integer>> cleanDirtyPages() {
        return ((State)this.state).globalCacheLock(true, () -> super.cleanDirtyPages());
    }

    @Override
    protected int unmapCandidate(List<Integer> pages, boolean clean) {
        return ((State)this.state).globalCacheLock(true, () -> super.unmapCandidate(pages, clean));
    }

    @Override
    protected int allocCachePage() {
        return ((State)this.state).globalCacheLock(true, () -> {
            int cache_page = super.allocCachePage();
            return cache_page;
        });
    }

    @Override
    protected byte[] map(int cachePage, int persistPage) {
        if (cachePage < 0) {
            throw new IllegalArgumentException("cachePage<0");
        }
        return ((State)this.state).globalCacheLock(true, () -> super.map(cachePage, persistPage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readPage(int page) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (page < 0) {
            throw new IllegalArgumentException("page<0");
        }
        boolean readLock_unlock = true;
        try {
            block13: {
                ((State)this.state).cacheLock.readLock().lock();
                int cidx = this.persist2cache(page);
                if (cidx >= 0) {
                    byte[] byArray = this.readPage_mapped(cidx, page);
                    return byArray;
                }
                ((State)this.state).cacheLock.readLock().unlock();
                readLock_unlock = false;
                try {
                    ((State)this.state).cacheLock.writeLock().lock();
                    cidx = this.persist2cache_mut(page);
                    if (cidx < 0) break block13;
                    byte[] byArray = this.readPage_mapped(cidx, page);
                    ((State)this.state).cacheLock.writeLock().unlock();
                    return byArray;
                }
                catch (Throwable throwable) {
                    ((State)this.state).cacheLock.writeLock().unlock();
                    throw throwable;
                }
            }
            byte[] byArray = this.readPage_alloc(page);
            ((State)this.state).cacheLock.writeLock().unlock();
            return byArray;
        }
        finally {
            if (readLock_unlock) {
                ((State)this.state).cacheLock.readLock().unlock();
            }
        }
    }

    @Override
    protected byte[] readPage_mapped(int cidx, int page) {
        return ((State)this.state).cachePageReadLock(cidx, () -> super.readPage_mapped(cidx, page));
    }

    @Override
    protected byte[] readPage_alloc(int page) {
        return super.readPage_alloc(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePage(int page, byte[] data) {
        block13: {
            if (this.isClosed()) {
                throw new IllegalStateException("closed");
            }
            if (page < 0) {
                throw new IllegalArgumentException("page<0");
            }
            boolean readLock_unlock = true;
            try {
                ((State)this.state).cacheLock.readLock().lock();
                int page_size = ((State)this.state).cachePages().memoryInfo().pageSize();
                if (data.length > page_size) {
                    throw new IllegalArgumentException("data.length(=" + data.length + ") > page_size(=" + page_size + ")");
                }
                int cidx = this.persist2cache(page);
                if (cidx >= 0) {
                    this.writePage_mapped(cidx, page, data);
                    break block13;
                }
                ((State)this.state).cacheLock.readLock().unlock();
                readLock_unlock = false;
                try {
                    ((State)this.state).cacheLock.writeLock().lock();
                    cidx = this.persist2cache_mut(page);
                    if (cidx >= 0) {
                        this.writePage_mapped(cidx, page, data);
                    } else {
                        this.writePage_alloc(page, data);
                    }
                }
                finally {
                    ((State)this.state).cacheLock.writeLock().unlock();
                }
            }
            finally {
                if (readLock_unlock) {
                    ((State)this.state).cacheLock.readLock().unlock();
                }
            }
        }
    }

    @Override
    protected void writePage_mapped(int cidx, int page, byte[] data) {
        ((State)this.state).cachePageWriteLock(cidx, () -> {
            super.writePage_mapped(cidx, page, data);
            return null;
        });
    }

    @Override
    protected void writePage_alloc(int page, byte[] data) {
        super.writePage_alloc(page, data);
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> extendPages(int pages) {
        return ((State)this.state).globalCacheLock(true, () -> super.extendPages(pages));
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> reducePages(int pages) {
        return ((State)this.state).globalCacheLock(true, () -> super.reducePages(pages));
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> resizeCachePages(int pages) {
        return ((State)this.state).globalCacheLock(true, () -> super.resizeCachePages(pages));
    }

    @Override
    public Tuple2<UsedPagesInfo, UsedPagesInfo> resizePages(int pages) {
        return ((State)this.state).globalCacheLock(true, () -> super.resizePages(pages));
    }

    protected List<Lock> lockPersistPages(int from, int toExc, Function<ReadWriteLock, Lock> lockType) {
        return ((State)this.state).globalCacheLock(true, () -> {
            ArrayList<Lock> lcks = new ArrayList<Lock>();
            Set cache_pages = ((State)this.state).prst2cache_read(map -> {
                TreeSet<Integer> cache_pages_1 = new TreeSet<Integer>();
                int p_from = Math.max(Math.min(from, toExc), 0);
                int p_to = Math.max(Math.max(from, toExc), 0);
                for (int p_i = p_from; p_i < p_to; ++p_i) {
                    Integer c_idx = (Integer)map.get(p_i);
                    if (c_idx == null) continue;
                    cache_pages_1.add(c_idx);
                }
                return cache_pages_1;
            });
            for (Integer cache_page : cache_pages) {
                Optional<ReadWriteLock> rwLock = ((State)this.state).cachePageRWLock(cache_page);
                if (!rwLock.isPresent()) continue;
                Lock lock = (Lock)lockType.apply(rwLock.get());
                lock.lock();
                lcks.add(lock);
            }
            return lcks;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePageLock(int from, int toExc, Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<Lock> locks = this.lockPersistPages(from, toExc, ReadWriteLock::writeLock);
        try {
            code.run();
        }
        finally {
            for (Lock lock : locks) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPageLock(int from, int toExc, Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("code==null");
        }
        List<Lock> locks = this.lockPersistPages(from, toExc, ReadWriteLock::readLock);
        try {
            code.run();
        }
        finally {
            for (Lock lock : locks) {
                lock.unlock();
            }
        }
    }

    private static class LockAll {
        private final List<Lock> locked;

        public LockAll(List<Lock> locked) {
            this.locked = locked;
        }

        public void release() {
            for (Lock lock : this.locked) {
                lock.unlock();
            }
            this.locked.clear();
        }
    }

    public static class State
    implements CachePagedState<UsedPagesInfo, DirtyPagedDataSafe> {
        protected DirtyPagedDataSafe cachePages;
        protected ResizablePages<UsedPagesInfo> persistentPages;
        protected volatile int[] cache2prst;
        protected Map<Integer, Integer> prst2cache;
        protected volatile boolean closed = false;
        protected volatile ReadWriteLock[] cachePageLocks = new ReadWriteLock[0];
        protected final AtomicLong statCacheHit = new AtomicLong(0L);
        protected final AtomicLong statCacheMiss = new AtomicLong(0L);
        private volatile int closeCall = 0;
        public final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

        @Override
        public void statCacheHitMiss(boolean hit) {
            AtomicLong a = hit ? this.statCacheHit : this.statCacheMiss;
            a.incrementAndGet();
        }

        @Override
        public Tuple2<Long, Long> statCacheHitMiss() {
            return Tuple2.of((Object)this.statCacheHit.get(), (Object)this.statCacheMiss.get());
        }

        public Optional<ReadWriteLock> cachePageRWLock(int cache_page) {
            if (cache_page < 0) {
                throw new IllegalArgumentException("cache_page<0");
            }
            ReadWriteLock[] cp = this.cachePageLocks;
            if (cp == null) {
                return Optional.empty();
            }
            if (cache_page >= cp.length) {
                throw new IllegalArgumentException("cache_page>=" + cp.length + "; out of range");
            }
            ReadWriteLock rwLock = cp[cache_page];
            if (rwLock != null) {
                return Optional.of(rwLock);
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R cachePageReadLock(int cache_page, Supplier<R> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            Optional<ReadWriteLock> rwOpt = this.cachePageRWLock(cache_page);
            if (rwOpt.isPresent()) {
                ReadWriteLock rwLock = rwOpt.get();
                try {
                    rwLock.readLock().lock();
                    R r = code.get();
                    return r;
                }
                finally {
                    rwLock.readLock().unlock();
                }
            }
            return code.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R cachePageWriteLock(int cache_page, Supplier<R> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            Optional<ReadWriteLock> rwOpt = this.cachePageRWLock(cache_page);
            if (rwOpt.isPresent()) {
                ReadWriteLock rwLock = rwOpt.get();
                try {
                    rwLock.writeLock().lock();
                    R r = code.get();
                    return r;
                }
                finally {
                    rwLock.writeLock().unlock();
                }
            }
            return code.get();
        }

        @Override
        public DirtyPagedDataSafe cachePages() {
            return this.cachePages;
        }

        @Override
        public void cachePages(DirtyPagedDataSafe pages) {
            this.cachePages = pages;
        }

        @Override
        public ResizablePages<UsedPagesInfo> persistentPages() {
            return this.persistentPages;
        }

        @Override
        public void persistentPages(ResizablePages<UsedPagesInfo> pages) {
            this.persistentPages = pages;
        }

        @Override
        public <R> R cache2prst_read(Function<IntArrayReadOnly, R> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            return code.apply(IntArrayReadOnly.of(this.cache2prst));
        }

        @Override
        public void cache2prst_write(Consumer<IntArrayMutable> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            code.accept(IntArrayMutable.of(this.cache2prst));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cache2prst_replace(Function<IntArrayReadOnly, int[]> code) {
            if (code == null) {
                throw new IllegalArgumentException("code==null");
            }
            ReadWriteLock[] cachePageLocks = this.cachePageLocks;
            ArrayList<Lock> writeLocks = new ArrayList<Lock>();
            if (cachePageLocks != null) {
                for (ReadWriteLock rwLock : cachePageLocks) {
                    if (rwLock == null) continue;
                    Lock lock = rwLock.writeLock();
                    lock.lock();
                    writeLocks.add(lock);
                }
            }
            try {
                int[] res = code.apply(IntArrayReadOnly.of(this.cache2prst == null ? new int[]{} : this.cache2prst));
                if (res == null) {
                    throw new IllegalStateException("cache2prst_replace(code), code - return null");
                }
                this.cache2prst = res;
                ReadWriteLock[] locks = new ReadWriteLock[res.length];
                for (int i = 0; i < this.cachePageLocks.length; ++i) {
                    locks[i] = new ReentrantReadWriteLock();
                }
                this.cachePageLocks = locks;
            }
            finally {
                for (Lock lock : writeLocks) {
                    lock.unlock();
                }
            }
        }

        @Override
        public Map<Integer, Integer> prst2cache() {
            return this.prst2cache;
        }

        @Override
        public void prst2cache(Map<Integer, Integer> map) {
            this.prst2cache = map;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() {
            try {
                ++this.closeCall;
                int closeCall_v = this.closeCall;
                if (closeCall_v > 1) {
                    throw new IllegalStateException("illegal cycle call close()");
                }
                if (!this.closed) {
                    ReadWriteLock[] cachePageLocks = this.cachePageLocks;
                    ArrayList<Lock> writeLocks = new ArrayList<Lock>();
                    if (cachePageLocks != null) {
                        for (ReadWriteLock rwLock : cachePageLocks) {
                            if (rwLock == null) continue;
                            Lock lock = rwLock.writeLock();
                            lock.lock();
                            writeLocks.add(lock);
                        }
                    }
                    try {
                        if (this.persistentPages instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)((Object)this.persistentPages)).close();
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                        this.persistentPages = null;
                        if (this.cachePages instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)((Object)this.cachePages)).close();
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                        this.cachePages = null;
                        this.cache2prst = null;
                        this.prst2cache = null;
                    }
                    finally {
                        for (Lock lock : writeLocks) {
                            lock.unlock();
                        }
                    }
                }
                this.closed = true;
            }
            finally {
                --this.closeCall;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R globalCacheLock(boolean write, Supplier<R> code) {
            if (write) {
                try {
                    this.cacheLock.writeLock().lock();
                    R r = code.get();
                    return r;
                }
                finally {
                    this.cacheLock.writeLock().unlock();
                }
            }
            try {
                this.cacheLock.readLock().lock();
                R r = code.get();
                return r;
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
    }
}

