/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.ContentBufferEvent;
import xyz.cofe.cbuffer.ContentBufferListener;
import xyz.cofe.cbuffer.SizeChangedEvent;
import xyz.cofe.ecolls.ListenersHelper;

public class MemContentBuffer
implements ContentBuffer {
    protected volatile byte[] data = new byte[0];
    protected volatile int dataSize = 0;
    protected volatile int extendSize = 0x100000;
    protected final ListenersHelper<ContentBufferListener, ContentBufferEvent> listeners = new ListenersHelper((ls, ev) -> {
        if (ls != null) {
            ls.contentBufferEvent((ContentBufferEvent)ev);
        }
    });

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(MemContentBuffer.class.getName()).log(Level.SEVERE, null, ex);
    }

    public MemContentBuffer() {
    }

    public MemContentBuffer(byte[] sourceData) {
        if (sourceData == null) {
            throw new IllegalArgumentException("sourceData==null");
        }
        this.data = sourceData;
        this.dataSize = this.data.length;
    }

    @Override
    public long getSize() {
        return this.dataSize;
    }

    @Override
    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size<0");
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size>Integer.MAX_VALUE");
        }
        if (this.data == null) {
            this.data = new byte[(int)size];
            this.dataSize = (int)size;
            this.fireEvent(new SizeChangedEvent(this, 0L, this.dataSize));
        } else if ((long)this.dataSize > size) {
            long old = this.dataSize;
            this.dataSize = (int)size;
            this.fireEvent(new SizeChangedEvent(this, old, this.dataSize));
        } else if ((long)this.dataSize < size) {
            long old = this.dataSize;
            if ((long)this.data.length < size) {
                int ext = (int)size % this.extendSize;
                int targetSize = (int)size / this.extendSize * (this.extendSize + (ext > 0 ? 1 : 0));
                this.data = Arrays.copyOf(this.data, targetSize);
            }
            this.dataSize = (int)size;
            this.fireEvent(new SizeChangedEvent(this, old, this.dataSize));
        }
    }

    @Override
    public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset<0");
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen<0");
        }
        if (dataLen == 0) {
            return;
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0");
        }
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("offset>Integer.MAX_VALUE");
        }
        int targetSize = (int)offset + dataLen;
        if (targetSize > this.dataSize) {
            this.setSize(targetSize);
        }
        System.arraycopy(data, dataOffset, this.data, (int)offset, dataLen);
    }

    @Override
    public byte[] get(long offset, int dataLen) {
        if (offset > Integer.MAX_VALUE) {
            return new byte[0];
        }
        if (this.data == null) {
            return new byte[0];
        }
        if ((int)offset >= this.dataSize) {
            return new byte[0];
        }
        if (this.dataSize < 1) {
            return new byte[0];
        }
        int minIdx = (int)offset;
        int targetEnd = (int)offset + dataLen;
        if (targetEnd > this.dataSize) {
            targetEnd = this.dataSize;
        }
        return Arrays.copyOfRange(this.data, minIdx, targetEnd);
    }

    @Override
    public void clear() {
        this.setSize(0L);
    }

    public ContentBuffer clone() {
        return new MemContentBuffer(this.data == null ? new byte[]{} : Arrays.copyOf(this.data, this.dataSize));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean hasListener(ContentBufferListener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    public Set<ContentBufferListener> getListeners() {
        return this.listeners.getListeners();
    }

    public AutoCloseable addListener(ContentBufferListener listener) {
        return this.listeners.addListener((Object)listener);
    }

    public AutoCloseable addListener(ContentBufferListener listener, boolean weakLink) {
        return this.listeners.addListener((Object)listener, weakLink);
    }

    public void removeListener(ContentBufferListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void fireEvent(ContentBufferEvent event) {
        this.listeners.fireEvent((Object)event);
    }
}

