/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.page.Changes;
import xyz.cofe.cbuffer.page.PageBuffersProperties;
import xyz.cofe.cbuffer.page.PageEvent;
import xyz.cofe.cbuffer.page.PageSizeProperty;

public class PageDataAbstract
implements PageSizeProperty,
PageBuffersProperties {
    private static final Logger log = Logger.getLogger(PageDataAbstract.class.getName());
    public final PageEvent<Changes<Integer>> onPageSizeChanged = new PageEvent();
    protected volatile int pageSize = 8192;
    public final PageEvent<Changes<ContentBuffer>> onFastBufferChanged = new PageEvent();
    protected volatile ContentBuffer fastBuffer;
    public final PageEvent<Changes<ContentBuffer>> onSlowBufferChanged = new PageEvent();
    protected volatile ContentBuffer slowBuffer;

    @Override
    public synchronized int getPageSize() {
        return this.pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPageSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size<1");
        }
        if (size < 256) {
            log.warning("setPageSize( " + size + ") to small");
        }
        int oldsize = this.pageSize;
        PageDataAbstract pageDataAbstract = this;
        synchronized (pageDataAbstract) {
            this.pageSize = size;
        }
        this.onPageSizeChanged.notify(Changes.of(oldsize, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentBuffer getFastBuffer() {
        PageDataAbstract pageDataAbstract = this;
        synchronized (pageDataAbstract) {
            return this.fastBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFastBuffer(ContentBuffer buff) {
        ContentBuffer old;
        PageDataAbstract pageDataAbstract = this;
        synchronized (pageDataAbstract) {
            old = this.fastBuffer;
            this.fastBuffer = buff;
        }
        this.onFastBufferChanged.notify(Changes.of(old, buff));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentBuffer getSlowBuffer() {
        PageDataAbstract pageDataAbstract = this;
        synchronized (pageDataAbstract) {
            return this.slowBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSlowBuffer(ContentBuffer buff) {
        ContentBuffer old;
        PageDataAbstract pageDataAbstract = this;
        synchronized (pageDataAbstract) {
            old = this.slowBuffer;
            this.slowBuffer = buff;
        }
        this.onSlowBufferChanged.notify(Changes.of(old, buff));
    }
}

