/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer.page;

import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.page.GetPageSize;
import xyz.cofe.cbuffer.page.PageBuffers;

public interface PageSlowWrite
extends GetPageSize,
PageBuffers {
    default public void slowData(int pageIndex, byte[] bytes) {
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex<0");
        }
        int pageSize = this.getPageSize();
        if (pageSize < 1) {
            throw new IllegalStateException("pageSize to small");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        if (bytes.length > pageSize) {
            throw new IllegalArgumentException("bytes.length > pageSize(=" + pageSize + ")");
        }
        ContentBuffer buff = this.getSlowBuffer();
        if (buff == null) {
            throw new IllegalStateException("slow buffer not available");
        }
        buff.set((long)pageSize * (long)pageIndex, bytes, 0, bytes.length);
    }
}

