/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.ContentBufferInputStream;
import xyz.cofe.cbuffer.ContentBufferOutputStream;
import xyz.cofe.io.fn.IOFun;

public class RAFBuffer
implements ContentBuffer {
    private static final Logger logger = Logger.getLogger(RAFBuffer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected boolean cloneRafContent = true;
    protected RandomAccessFile raf;
    protected boolean throwNotSetRaf = true;
    protected boolean deleteTempOnExit = true;
    protected boolean flushOnClose = true;
    protected boolean closeRaf = true;
    protected boolean releaseRaf = true;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public RAFBuffer() {
        this.lock = new ReentrantLock();
    }

    public RAFBuffer(Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
    }

    public RAFBuffer(RAFBuffer src) {
        this(src, new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAFBuffer(RAFBuffer src, Lock lock) {
        Lock lock2 = this.lock = lock == null ? new ReentrantLock() : lock;
        if (src != null) {
            try {
                src.lock.lock();
                if (src.cloneRafContent) {
                    RandomAccessFile traf;
                    this.raf = traf = src.createTempRAF();
                    RandomAccessFile rafSrc = src.raf;
                    RandomAccessFile rafDest = traf;
                    if (rafSrc != null && rafDest != null) {
                        ContentBufferInputStream cin = null;
                        cin = new ContentBufferInputStream(src);
                        ContentBufferOutputStream cout = null;
                        cout = new ContentBufferOutputStream(this);
                        try {
                            IOFun.copy((InputStream)cin, (OutputStream)cout);
                        }
                        catch (IOException err) {
                            throw new IOError(err);
                        }
                        try {
                            cout.close();
                        }
                        catch (IOException err) {
                            throw new IOError(err);
                        }
                        try {
                            cin.close();
                        }
                        catch (IOException err) {
                            throw new IOError(err);
                        }
                    }
                    this.raf = src.raf;
                }
                this.throwNotSetRaf = src.throwNotSetRaf;
                this.flushOnClose = src.flushOnClose;
                this.cloneRafContent = src.cloneRafContent;
                this.closeRaf = src.closeRaf;
                this.deleteTempOnExit = src.deleteTempOnExit;
                this.releaseRaf = src.releaseRaf;
            }
            finally {
                src.lock.unlock();
            }
        }
    }

    public boolean isCloneRafContent() {
        try {
            this.lock.lock();
            boolean bl = this.cloneRafContent;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCloneRafContent(boolean cloneRafContent) {
        try {
            this.lock.lock();
            this.cloneRafContent = cloneRafContent;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    public RandomAccessFile getRaf() {
        try {
            this.lock.lock();
            RandomAccessFile randomAccessFile = this.raf;
            return randomAccessFile;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRaf(RandomAccessFile raf) {
        try {
            this.lock.lock();
            this.raf = raf;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isThrowNotSetRaf() {
        try {
            this.lock.lock();
            boolean bl = this.throwNotSetRaf;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setThrowNotSetRaf(boolean throwNotSetRaf) {
        try {
            this.lock.lock();
            this.throwNotSetRaf = throwNotSetRaf;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getSize() {
        try {
            this.lock.lock();
            if (this.raf == null) {
                if (this.throwNotSetRaf) {
                    throw new IllegalStateException("property raf not set");
                }
                long l = 0L;
                return l;
            }
            long l = this.raf.length();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(long size) {
        try {
            this.lock.lock();
            if (this.raf == null) {
                if (this.throwNotSetRaf) {
                    throw new IllegalStateException("property raf not set");
                }
                return;
            }
            try {
                this.raf.setLength(0L);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long offset, byte[] data, int dataOffset, int dataLen) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset(" + offset + ")<0");
        }
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (dataOffset < 0) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")<0");
        }
        if (dataOffset >= data.length) {
            throw new IllegalArgumentException("dataOffset(" + dataOffset + ")>=data.length(" + data.length + ")");
        }
        if (dataLen == 0) {
            return;
        }
        if (dataLen < 0) {
            throw new IllegalArgumentException("dataLen(" + dataLen + ")<0");
        }
        if (dataLen + dataOffset > data.length) {
            throw new IllegalArgumentException("dataLen(" + dataLen + ")+dataOffset(" + dataOffset + ")>data.length(" + data.length + ")");
        }
        try {
            this.lock.lock();
            if (this.raf == null) {
                if (this.throwNotSetRaf) {
                    throw new IllegalStateException("property raf not set");
                }
                return;
            }
            try {
                this.raf.seek(offset);
                this.raf.write(data, dataOffset, dataLen);
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] get(long offset, int dataLen) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void clear() {
        this.setSize(0L);
    }

    public boolean isDeleteTempOnExit() {
        try {
            this.lock.lock();
            boolean bl = this.deleteTempOnExit;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDeleteTempOnExit(boolean deleteTempOnExit) {
        try {
            this.lock.lock();
            this.deleteTempOnExit = deleteTempOnExit;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected File createTempFile() {
        try {
            File tempFile = File.createTempFile("rafBuffer", ".tmp");
            return tempFile;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    protected RandomAccessFile createTempRAF() {
        if (this.raf == null) {
            if (this.throwNotSetRaf) {
                throw new IllegalStateException("property raf not set");
            }
            return null;
        }
        File tempFile = null;
        try {
            tempFile = this.createTempFile();
            if (this.deleteTempOnExit) {
                tempFile.deleteOnExit();
            }
            RandomAccessFile traf = new RandomAccessFile(tempFile, "rw");
            return traf;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public RAFBuffer clone() {
        try {
            this.lock.lock();
            if (this.raf == null) {
                if (this.throwNotSetRaf) {
                    throw new IllegalStateException("property raf not set");
                }
                RAFBuffer rAFBuffer = new RAFBuffer(this);
                return rAFBuffer;
            }
            RAFBuffer rAFBuffer = new RAFBuffer(this);
            return rAFBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
        if (this.raf == null) {
            if (this.throwNotSetRaf) {
                throw new IllegalStateException("property raf not set");
            }
            return;
        }
        try {
            this.raf.getFD().sync();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public boolean isFlushOnClose() {
        try {
            this.lock.lock();
            boolean bl = this.flushOnClose;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setFlushOnClose(boolean flushOnClose) {
        try {
            this.lock.lock();
            this.flushOnClose = flushOnClose;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCloseRaf() {
        try {
            this.lock.lock();
            boolean bl = this.closeRaf;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCloseRaf(boolean closeRaf) {
        try {
            this.lock.lock();
            this.closeRaf = closeRaf;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isReleaseRaf() {
        try {
            this.lock.lock();
            boolean bl = this.releaseRaf;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setReleaseRaf(boolean releaseRaf) {
        try {
            this.lock.lock();
            this.releaseRaf = releaseRaf;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            if (this.raf == null) {
                return;
            }
            if (this.flushOnClose) {
                this.flush();
            }
            try {
                if (this.closeRaf) {
                    this.raf.close();
                }
            }
            catch (IOException ex) {
                throw new IOError(ex);
            }
            if (this.releaseRaf) {
                this.raf = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

