/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.cbuffer.ContentBufferOutputStream;
import xyz.cofe.cbuffer.SyncContentBuffer;
import xyz.cofe.io.fn.IOFun;

public class ContentBufferFuncs {
    private static final Logger logger = Logger.getLogger(ContentBufferFuncs.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public long readStreamInto(InputStream stream, ContentBuffer cbuf) {
        return this.readStreamInto(stream, 0L, -1L, cbuf, 0L, -1L, 8192, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readStreamInto(final InputStream stream, final long skip, final long maxRead, final ContentBuffer cbuf, long bufferBeginIndex, long bufferEndIndexExclusive, final int blockSize, final Consumer<Long> progress) {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        if (cbuf == null) {
            throw new IllegalArgumentException("cbuf==null");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize<1");
        }
        if (bufferBeginIndex >= 0L && bufferEndIndexExclusive >= 0L && bufferBeginIndex > bufferEndIndexExclusive) {
            long t = bufferBeginIndex;
            bufferBeginIndex = bufferEndIndexExclusive;
            bufferEndIndexExclusive = t;
        }
        final long fbuffBeginIndex = bufferBeginIndex;
        final long fbuffEndIndexExc = bufferEndIndexExclusive;
        Object osync = cbuf instanceof SyncContentBuffer ? ((SyncContentBuffer)cbuf).getSyncObject() : null;
        Supplier fn = new Supplier(){

            public Object get() {
                ContentBufferOutputStream cout = null;
                cout = fbuffBeginIndex < 0L ? (fbuffEndIndexExc < 0L ? new ContentBufferOutputStream(cbuf) : new ContentBufferOutputStream(cbuf, 0L, fbuffEndIndexExc)) : (fbuffEndIndexExc < 0L ? new ContentBufferOutputStream(cbuf, fbuffBeginIndex) : new ContentBufferOutputStream(cbuf, fbuffBeginIndex, fbuffEndIndexExc));
                long total = 0L;
                try {
                    if (skip > 0L) {
                        int readed;
                        byte[] dblock = new byte[blockSize];
                        for (long skipped = 0L; skipped < skip; skipped += (long)readed) {
                            int toread = 0;
                            long residue = skip - skipped;
                            toread = residue > (long)blockSize ? blockSize : (int)residue;
                            readed = stream.read(dblock, 0, toread);
                            if (readed < 0) break;
                        }
                    }
                    total = IOFun.copy((InputStream)stream, (OutputStream)cout, (long)maxRead, (int)blockSize, (Consumer)progress);
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
                try {
                    cout.close();
                }
                catch (IOException ex) {
                    ContentBufferFuncs.logException(ex);
                }
                return total;
            }
        };
        if (osync != null) {
            Object object = osync;
            synchronized (object) {
                return (Long)fn.get();
            }
        }
        return (Long)fn.get();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

