/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cbuffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xyz.cofe.cbuffer.ContentBuffer;

public class ContentBufferInputStream
extends InputStream {
    protected Lock lock = null;
    protected ContentBuffer contentBuffer = null;
    protected long beginIndex = -1L;
    protected long endIndexExclusive = -1L;
    protected long pointer = 0L;

    public ContentBufferInputStream(ContentBuffer buffer, long beginIndex, long endIndexExclusive, Lock lock) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer == null");
        }
        if (beginIndex < 0L) {
            beginIndex = 0L;
        }
        this.contentBuffer = buffer;
        this.beginIndex = beginIndex;
        this.endIndexExclusive = endIndexExclusive;
        this.pointer = beginIndex;
        this.lock = lock;
    }

    public ContentBufferInputStream(ContentBuffer buffer, long beginIndex, long endIndexExclusive) {
        this(buffer, beginIndex, endIndexExclusive, new ReentrantLock());
    }

    public ContentBufferInputStream(ContentBuffer buffer, long beginIndex) {
        this(buffer, beginIndex, -1L);
    }

    public ContentBufferInputStream(ContentBuffer buffer) {
        this(buffer, 0L, -1L);
    }

    @Override
    public int read() throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                int n = this.read0();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.read0();
    }

    private int read0() throws IOException {
        if (this.contentBuffer == null) {
            return -1;
        }
        if (this.endIndexExclusive >= 0L && this.pointer >= this.endIndexExclusive) {
            return -1;
        }
        byte[] buff = this.contentBuffer.get(this.pointer, 1);
        if (buff == null || buff.length == 0) {
            return -1;
        }
        ++this.pointer;
        return buff[0] + 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                int readed;
                int n = readed = this.read0(b, off, len);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
        int readed = this.read(b, off, len);
        return readed;
    }

    private int read0(byte[] b, int off, int len) throws IOException {
        byte[] bb;
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (len == 0) {
            return 0;
        }
        if (off >= b.length) {
            throw new IllegalArgumentException("off >= b.length");
        }
        if (off + len > b.length) {
            throw new IllegalArgumentException("off + len > b.length");
        }
        if (this.endIndexExclusive >= 0L) {
            if (this.pointer >= this.endIndexExclusive) {
                return -1;
            }
            if (this.pointer + (long)len >= this.endIndexExclusive) {
                long diff = this.pointer + (long)len + this.endIndexExclusive;
                len = diff > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)diff;
            }
        }
        if ((bb = this.contentBuffer.get(this.pointer, len)) == null || bb.length == 0) {
            return -1;
        }
        System.arraycopy(bb, 0, b, off, bb.length);
        this.pointer += (long)bb.length;
        return bb.length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                this.contentBuffer = null;
            }
            finally {
                this.lock.unlock();
            }
            this.lock = null;
        } else {
            this.contentBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (this.lock != null) {
            this.lock.lock();
            try {
                long l = this.skip0(n);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.skip0(n);
    }

    private long skip0(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.contentBuffer == null) {
            return 0L;
        }
        if (this.pointer >= this.endIndexExclusive) {
            return 0L;
        }
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        this.pointer += n;
        return n;
    }
}

