/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.InvalidResponseException;
import xyz.capybara.clamav.ScanFailureException;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\b"}, d2={"Lxyz/capybara/clamav/commands/scan/ScanCommand;", "Lxyz/capybara/clamav/commands/Command;", "Lxyz/capybara/clamav/commands/scan/result/ScanResult;", "()V", "parseResponse", "responseString", "", "Companion", "clamav-client"})
public abstract class ScanCommand
extends Command<ScanResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex RESPONSE_OK = new Regex("(.+) OK$", RegexOption.UNIX_LINES);
    @NotNull
    private static final Regex RESPONSE_VIRUS_FOUND;
    @NotNull
    private static final Regex RESPONSE_ERROR;
    @NotNull
    private static final Regex RESPONSE_VIRUS_FOUND_LINE;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ScanResult parseResponse(@NotNull String responseString) {
        Intrinsics.checkNotNullParameter((Object)responseString, (String)"responseString");
        try {
            ScanResult scanResult;
            if (RESPONSE_OK.matches((CharSequence)responseString)) {
                scanResult = ScanResult.OK.INSTANCE;
            } else if (RESPONSE_VIRUS_FOUND.containsMatchIn((CharSequence)responseString)) {
                void $this$groupByTo$iv$iv;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object object = responseString;
                Regex regex = new Regex("\n");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                regex = RESPONSE_VIRUS_FOUND_LINE;
                boolean $i$f$mapNotNull22 = false;
                void var6_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    MatchResult it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    CharSequence p0 = (CharSequence)element$iv$iv;
                    boolean bl2 = false;
                    if (regex.matchEntire(p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                Iterable $i$f$mapNotNull22 = $this$map$iv;
                Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MatchResult $i$f$forEach2 = (MatchResult)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(CollectionsKt.reversed((Iterable)((Iterable)it.getGroups())));
                }
                Iterable $this$groupBy$iv = (List)destination$iv$iv2;
                boolean $i$f$groupBy = false;
                $this$mapTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    void it;
                    Object object2;
                    List it2 = (List)element$iv$iv;
                    boolean $i$a$-groupBy-ScanCommand$parseResponse$foundViruses$52 = false;
                    Object e = it2.get(1);
                    Intrinsics.checkNotNull(e);
                    String key$iv$iv = ((MatchGroup)e).getValue();
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    List $i$a$-groupBy-ScanCommand$parseResponse$foundViruses$52 = (List)element$iv$iv;
                    collection = list$iv$iv;
                    boolean bl = false;
                    Object e2 = it.get(0);
                    Intrinsics.checkNotNull(e2);
                    collection.add(((MatchGroup)e2).getValue());
                }
                Object foundViruses = destination$iv$iv2;
                scanResult = new ScanResult.VirusFound((Map<String, ? extends Collection<String>>)foundViruses);
            } else {
                if (RESPONSE_ERROR.matches((CharSequence)responseString)) {
                    throw new ScanFailureException(responseString);
                }
                throw new InvalidResponseException(responseString);
            }
            return scanResult;
        }
        catch (IllegalStateException e) {
            throw new InvalidResponseException(responseString);
        }
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.MULTILINE, RegexOption.UNIX_LINES};
        RESPONSE_VIRUS_FOUND = new Regex("(.+) FOUND$", SetsKt.setOf((Object[])objectArray));
        RESPONSE_ERROR = new Regex("(.+) ERROR", RegexOption.UNIX_LINES);
        RESPONSE_VIRUS_FOUND_LINE = new Regex("(.+: )?(.+): (.+) FOUND$", RegexOption.UNIX_LINES);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lxyz/capybara/clamav/commands/scan/ScanCommand$Companion;", "", "()V", "RESPONSE_ERROR", "Lkotlin/text/Regex;", "RESPONSE_OK", "RESPONSE_VIRUS_FOUND", "RESPONSE_VIRUS_FOUND_LINE", "clamav-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

