/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands.scan;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.CommunicationException;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.scan.ScanCommand;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/capybara/clamav/commands/scan/InStream;", "Lxyz/capybara/clamav/commands/scan/ScanCommand;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "commandString", "", "getCommandString", "()Ljava/lang/String;", "format", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "getFormat", "()Lxyz/capybara/clamav/commands/Command$CommandFormat;", "send", "Lxyz/capybara/clamav/commands/scan/result/ScanResult;", "server", "Ljava/net/InetSocketAddress;", "Companion", "clamav-client"})
public final class InStream
extends ScanCommand {
    private final InputStream inputStream;
    private static final int CHUNK_SIZE = 2048;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getCommandString() {
        return "INSTREAM";
    }

    @Override
    @NotNull
    protected Command.CommandFormat getFormat() {
        return Command.CommandFormat.NULL_CHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ScanResult send(@NotNull InetSocketAddress server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        try {
            Closeable closeable;
            ScanResult scanResult;
            Closeable closeable2 = SocketChannel.open(server);
            boolean bl = false;
            try {
                SocketChannel it = (SocketChannel)closeable2;
                it.write(this.getRawCommand());
                ByteBuffer length = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
                byte[] data = new byte[2048];
                int chunkSize = 2048;
                while (chunkSize == 2048) {
                    chunkSize = this.inputStream.read(data);
                    if (chunkSize <= 0) continue;
                    length.clear();
                    length.putInt(chunkSize).flip();
                    it.write(length);
                    it.write(ByteBuffer.wrap(data, 0, chunkSize));
                }
                length.clear();
                length.putInt(0).flip();
                it.write(length);
                SocketChannel socketChannel = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)socketChannel, (String)"it");
                scanResult = (ScanResult)this.readResponse(socketChannel);
                closeable = closeable2;
            }
            catch (Exception exception) {
                try {
                    bl = true;
                    try {
                        Closeable closeable3 = closeable2;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        Closeable closeable4 = closeable2;
                        if (closeable4 != null) {
                            closeable4.close();
                        }
                    }
                    throw throwable;
                }
            }
            if (closeable != null) {
                closeable.close();
            }
            return scanResult;
        }
        catch (IOException e) {
            throw (Throwable)new CommunicationException(e);
        }
    }

    public InStream(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lxyz/capybara/clamav/commands/scan/InStream$Companion;", "", "()V", "CHUNK_SIZE", "", "clamav-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

