/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav.commands;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.ClamavException;
import xyz.capybara.clamav.CommunicationException;
import xyz.capybara.clamav.UnknownCommandException;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u001d*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0005H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0005\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lxyz/capybara/clamav/commands/Command;", "T", "", "()V", "commandString", "", "getCommandString", "()Ljava/lang/String;", "format", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "getFormat", "()Lxyz/capybara/clamav/commands/Command$CommandFormat;", "rawCommand", "Ljava/nio/ByteBuffer;", "getRawCommand", "()Ljava/nio/ByteBuffer;", "parseResponse", "responseString", "(Ljava/lang/String;)Ljava/lang/Object;", "readResponse", "socketChannel", "Ljava/nio/channels/SocketChannel;", "(Ljava/nio/channels/SocketChannel;)Ljava/lang/Object;", "removeResponseTerminator", "send", "server", "Ljava/net/InetSocketAddress;", "(Ljava/net/InetSocketAddress;)Ljava/lang/Object;", "CommandFormat", "Companion", "clamav-client"})
public abstract class Command<T> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getCommandString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T send(@NotNull InetSocketAddress server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        try {
            Closeable closeable;
            T t;
            Closeable closeable2 = SocketChannel.open(server);
            boolean bl = false;
            try {
                SocketChannel it = (SocketChannel)closeable2;
                it.write(this.getRawCommand());
                SocketChannel socketChannel = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)socketChannel, (String)"it");
                t = this.readResponse(socketChannel);
                closeable = closeable2;
            }
            catch (Exception exception) {
                try {
                    bl = true;
                    try {
                        Closeable closeable3 = closeable2;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        Closeable closeable4 = closeable2;
                        if (closeable4 != null) {
                            closeable4.close();
                        }
                    }
                    throw throwable;
                }
            }
            if (closeable != null) {
                closeable.close();
            }
            return t;
        }
        catch (IOException e) {
            throw (Throwable)new CommunicationException(e);
        }
    }

    @NotNull
    protected abstract CommandFormat getFormat();

    @NotNull
    protected ByteBuffer getRawCommand() {
        String string = "" + this.getFormat().getPrefix() + "" + this.getCommandString() + "" + this.getFormat().getTerminator();
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.US_ASCII");
        Charset charset2 = charset;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(\"${forma\u2026andardCharsets.US_ASCII))");
        return byteBuffer;
    }

    protected final T readResponse(@NotNull SocketChannel socketChannel) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)socketChannel, (String)"socketChannel");
        StringBuilder responseStringBuilder = new StringBuilder();
        ByteBuffer rawResponsePart = ByteBuffer.allocate(32);
        int read = socketChannel.read(rawResponsePart);
        while (read > -1) {
            Charset charset;
            byte[] byArray = rawResponsePart.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"rawResponsePart.array()");
            Object object = byArray;
            Intrinsics.checkExpressionValueIsNotNull((Object)StandardCharsets.US_ASCII, (String)"StandardCharsets.US_ASCII");
            String rawResponsePartString = new String((byte[])object, charset);
            object = rawResponsePartString;
            int n = 0;
            String string = ((String)object).substring(n, read);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            rawResponsePartString = string;
            responseStringBuilder.append(rawResponsePartString);
            rawResponsePart = ByteBuffer.allocate(32);
            read = socketChannel.read(rawResponsePart);
        }
        String string = responseStringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseStringBuilder.toString()");
        String responseString = this.removeResponseTerminator(string);
        if (Intrinsics.areEqual((Object)responseString, (Object)"UNKNOWN COMMAND")) {
            throw (Throwable)new UnknownCommandException(this.getCommandString());
        }
        Companion.getLogger().debug((Function0)new Function0<String>(this, responseString){
            final /* synthetic */ Command this$0;
            final /* synthetic */ String $responseString;

            @NotNull
            public final String invoke() {
                return "" + this.this$0.getCommandString() + " - Response: " + this.$responseString;
            }
            {
                this.this$0 = command;
                this.$responseString = string;
                super(0);
            }
        });
        return this.parseResponse(responseString);
    }

    private final String removeResponseTerminator(String responseString) {
        String string = responseString;
        int n = 0;
        int n2 = StringsKt.lastIndexOf$default((CharSequence)responseString, (char)this.getFormat().getTerminator(), (int)0, (boolean)false, (int)6, null);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    protected abstract T parseResponse(@NotNull String var1);

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lxyz/capybara/clamav/commands/Command$CommandFormat;", "", "prefix", "", "terminator", "(Ljava/lang/String;ICC)V", "getPrefix", "()C", "getTerminator", "NULL_CHAR", "NEW_LINE", "Companion", "clamav-client"})
    public static final class CommandFormat
    extends Enum<CommandFormat> {
        public static final /* enum */ CommandFormat NULL_CHAR;
        public static final /* enum */ CommandFormat NEW_LINE;
        private static final /* synthetic */ CommandFormat[] $VALUES;
        private final char prefix;
        private final char terminator;
        public static final Companion Companion;

        static {
            CommandFormat[] commandFormatArray = new CommandFormat[2];
            CommandFormat[] commandFormatArray2 = commandFormatArray;
            commandFormatArray[0] = NULL_CHAR = new CommandFormat('z', '\u0000');
            commandFormatArray[1] = NEW_LINE = new CommandFormat('n', '\n');
            $VALUES = commandFormatArray;
            Companion = new Companion(null);
        }

        public final char getPrefix() {
            return this.prefix;
        }

        public final char getTerminator() {
            return this.terminator;
        }

        protected CommandFormat(char prefix, char terminator) {
            this.prefix = prefix;
            this.terminator = terminator;
        }

        public static CommandFormat[] values() {
            return (CommandFormat[])$VALUES.clone();
        }

        public static CommandFormat valueOf(String string) {
            return Enum.valueOf(CommandFormat.class, string);
        }

        @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/capybara/clamav/commands/Command$CommandFormat$Companion;", "", "()V", "fromPrefix", "Lxyz/capybara/clamav/commands/Command$CommandFormat;", "prefix", "", "clamav-client"})
        public static final class Companion {
            @NotNull
            public final CommandFormat fromPrefix(char prefix) {
                CommandFormat commandFormat;
                switch (prefix) {
                    case 'z': {
                        commandFormat = NULL_CHAR;
                        break;
                    }
                    case 'n': {
                        commandFormat = NEW_LINE;
                        break;
                    }
                    default: {
                        throw (Throwable)new ClamavException(new IllegalArgumentException(String.valueOf(prefix)));
                    }
                }
                return commandFormat;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lxyz/capybara/clamav/commands/Command$Companion;", "Lmu/KLogging;", "()V", "clamav-client"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

