/*
 * Decompiled with CFR 0.152.
 */
package xyz.capybara.clamav;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import xyz.capybara.clamav.ClamavException;
import xyz.capybara.clamav.Platform;
import xyz.capybara.clamav.UnsupportedCommandException;
import xyz.capybara.clamav.commands.Command;
import xyz.capybara.clamav.commands.Ping;
import xyz.capybara.clamav.commands.Reload;
import xyz.capybara.clamav.commands.Shutdown;
import xyz.capybara.clamav.commands.Stats;
import xyz.capybara.clamav.commands.Version;
import xyz.capybara.clamav.commands.VersionCommands;
import xyz.capybara.clamav.commands.scan.ContScan;
import xyz.capybara.clamav.commands.scan.InStream;
import xyz.capybara.clamav.commands.scan.MultiScan;
import xyz.capybara.clamav.commands.scan.Scan;
import xyz.capybara.clamav.commands.scan.ScanCommand;
import xyz.capybara.clamav.commands.scan.result.ScanResult;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0019\b\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001cH\u0007J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001a\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J!\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&H\u0003\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u001cH\u0007J\b\u0010)\u001a\u00020\u0003H\u0007J\b\u0010*\u001a\u00020\u0003H\u0007R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006,"}, d2={"Lxyz/capybara/clamav/ClamavClient;", "", "serverHostname", "", "serverPlatform", "Lxyz/capybara/clamav/Platform;", "(Ljava/lang/String;Lxyz/capybara/clamav/Platform;)V", "serverPort", "", "(Ljava/lang/String;ILxyz/capybara/clamav/Platform;)V", "server", "Ljava/net/InetSocketAddress;", "(Ljava/net/InetSocketAddress;Lxyz/capybara/clamav/Platform;)V", "availableCommands", "", "getAvailableCommands", "()Ljava/util/Collection;", "availableCommands$delegate", "Lkotlin/Lazy;", "getServer", "()Ljava/net/InetSocketAddress;", "getServerPlatform", "()Lxyz/capybara/clamav/Platform;", "parallelScan", "Lxyz/capybara/clamav/commands/scan/result/ScanResult;", "path", "Ljava/nio/file/Path;", "ping", "", "reloadVirusDatabases", "scan", "inputStream", "Ljava/io/InputStream;", "continueScan", "", "sendCommand", "T", "command", "Lxyz/capybara/clamav/commands/Command;", "(Lxyz/capybara/clamav/commands/Command;)Ljava/lang/Object;", "shutdownServer", "stats", "version", "Companion", "clamav-client"})
public final class ClamavClient {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy availableCommands$delegate;
    @NotNull
    private final InetSocketAddress server;
    @NotNull
    private final Platform serverPlatform;
    @JvmField
    public static final int DEFAULT_SERVER_PORT = 3310;
    @JvmField
    @NotNull
    public static final Platform DEFAULT_SERVER_PLATFORM;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ClamavClient.class), "availableCommands", "getAvailableCommands()Ljava/util/Collection;"))};
        Companion = new Companion(null);
        DEFAULT_SERVER_PORT = 3310;
        DEFAULT_SERVER_PLATFORM = Platform.JVM_PLATFORM;
    }

    private final Collection<String> getAvailableCommands() {
        Lazy lazy = this.availableCommands$delegate;
        ClamavClient clamavClient = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Collection)lazy.getValue();
    }

    public final void ping() throws ClamavException {
        this.sendCommand(Ping.INSTANCE);
    }

    @NotNull
    public final String version() throws ClamavException {
        return (String)this.sendCommand(Version.INSTANCE);
    }

    @NotNull
    public final String stats() throws ClamavException {
        return (String)this.sendCommand(Stats.INSTANCE);
    }

    public final void reloadVirusDatabases() throws ClamavException {
        this.sendCommand(Reload.INSTANCE);
    }

    public final void shutdownServer() throws ClamavException {
        this.sendCommand(Shutdown.INSTANCE);
    }

    @NotNull
    public final ScanResult scan(@NotNull InputStream inputStream) throws ClamavException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        return (ScanResult)this.sendCommand(new InStream(inputStream));
    }

    @JvmOverloads
    @NotNull
    public final ScanResult scan(@NotNull Path path, boolean continueScan) throws ClamavException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (ScanResult)this.sendCommand(continueScan ? (ScanCommand)new ContScan(this.serverPlatform.toServerPath(path)) : (ScanCommand)new Scan(this.serverPlatform.toServerPath(path)));
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ScanResult scan$default(ClamavClient clamavClient, Path path, boolean bl, int n, Object object) throws ClamavException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return clamavClient.scan(path, bl);
    }

    @JvmOverloads
    @NotNull
    public final ScanResult scan(@NotNull Path path) throws ClamavException {
        return ClamavClient.scan$default(this, path, false, 2, null);
    }

    @NotNull
    public final ScanResult parallelScan(@NotNull Path path) throws ClamavException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return (ScanResult)this.sendCommand(new MultiScan(this.serverPlatform.toServerPath(path)));
    }

    private final <T> T sendCommand(Command<? extends T> command) throws ClamavException {
        try {
            if (this.getAvailableCommands().contains(command.getCommandString())) {
                return command.send(this.server);
            }
            throw (Throwable)new UnsupportedCommandException(command.getCommandString());
        }
        catch (RuntimeException cause) {
            throw (Throwable)new ClamavException(cause);
        }
    }

    @NotNull
    public final InetSocketAddress getServer() {
        return this.server;
    }

    @NotNull
    public final Platform getServerPlatform() {
        return this.serverPlatform;
    }

    @JvmOverloads
    public ClamavClient(@NotNull InetSocketAddress server, @NotNull Platform serverPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)((Object)serverPlatform), (String)"serverPlatform");
        this.server = server;
        this.serverPlatform = serverPlatform;
        this.availableCommands$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Collection<? extends String>>(this){
            final /* synthetic */ ClamavClient this$0;

            @NotNull
            public final Collection<String> invoke() {
                return (Collection)VersionCommands.INSTANCE.send(this.this$0.getServer());
            }
            {
                this.this$0 = clamavClient;
                super(0);
            }
        }));
    }

    @JvmOverloads
    public /* synthetic */ ClamavClient(InetSocketAddress inetSocketAddress, Platform platform, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            platform = DEFAULT_SERVER_PLATFORM;
        }
        this(inetSocketAddress, platform);
    }

    @JvmOverloads
    public ClamavClient(@NotNull InetSocketAddress server) {
        this(server, null, 2, null);
    }

    public ClamavClient(@NotNull String serverHostname, @NotNull Platform serverPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)serverHostname, (String)"serverHostname");
        Intrinsics.checkParameterIsNotNull((Object)((Object)serverPlatform), (String)"serverPlatform");
        this(serverHostname, DEFAULT_SERVER_PORT, serverPlatform);
    }

    @JvmOverloads
    public ClamavClient(@NotNull String serverHostname, int serverPort, @NotNull Platform serverPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)serverHostname, (String)"serverHostname");
        Intrinsics.checkParameterIsNotNull((Object)((Object)serverPlatform), (String)"serverPlatform");
        this(new InetSocketAddress(serverHostname, serverPort), serverPlatform);
    }

    @JvmOverloads
    public /* synthetic */ ClamavClient(String string, int n, Platform platform, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = DEFAULT_SERVER_PORT;
        }
        if ((n2 & 4) != 0) {
            platform = DEFAULT_SERVER_PLATFORM;
        }
        this(string, n, platform);
    }

    @JvmOverloads
    public ClamavClient(@NotNull String serverHostname, int serverPort) {
        this(serverHostname, serverPort, null, 4, null);
    }

    @JvmOverloads
    public ClamavClient(@NotNull String serverHostname) {
        this(serverHostname, 0, null, 6, null);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/capybara/clamav/ClamavClient$Companion;", "", "()V", "DEFAULT_SERVER_PLATFORM", "Lxyz/capybara/clamav/Platform;", "DEFAULT_SERVER_PORT", "", "clamav-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

