/*
 * Decompiled with CFR 0.152.
 */
package com.belvi.validator;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.belvi.validator.PhoneFormatException;
import com.belvi.validator.PhoneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PhoneNumberValidator {
    private ArrayList<Country> countriesList;

    public Country getCountryByName(String countries) {
        for (Country c : Country.values()) {
            if (!String.valueOf((Object)c).equalsIgnoreCase(countries)) continue;
            return c;
        }
        return null;
    }

    public Country getCountryByPhoneNumber(Country defaultCountry, String phoneNumber) throws PhoneFormatException {
        for (Country c : Country.values()) {
            PhoneModel model;
            if (!(c.startWithCountryCode(String.valueOf(c.getCountryCode()), phoneNumber) ? (model = c.isNumberValid(c, phoneNumber)).isValidPhoneNumber() : c.startWithPlusAndCountryCode(String.valueOf(c.getCountryCode()), phoneNumber) && (model = c.isNumberValid(c, phoneNumber)).isValidPhoneNumber())) continue;
            return c;
        }
        return defaultCountry;
    }

    public Country getCountryByMcc(int mcc) {
        for (Country countries : Country.values()) {
            if (!countries.mcc.contains(mcc)) continue;
            return countries;
        }
        return null;
    }

    public ArrayList<Country> getCountriesByCountryCode(int countryCode) {
        this.countriesList = new ArrayList();
        for (Country countries : Country.values()) {
            if (countries.countryCode != countryCode) continue;
            this.countriesList.add(countries);
        }
        return this.countriesList;
    }

    public Country getUserCountry(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String simOperator = telephonyManager.getSimOperator();
        if (!simOperator.isEmpty()) {
            int mcc = Integer.parseInt(String.valueOf(context.getResources().getConfiguration().mcc));
            return this.getCountryByMcc(mcc);
        }
        return null;
    }

    public static enum Country {
        Benin("Benin Republic", 229, 8, 8, "0", 616),
        BurkinaFaso("Burkina Faso", 226, 8, 8, "0", 613),
        CapeVerde("Cape Verce", 238, 7, 7, "0", 614),
        Cameroon("Cameroon", 237, 8, 8, "0", 302, 307),
        Canada("Canada,", 1, 10, 10, "0,1", 460),
        China("China", 86, 11, 11, "0", 612),
        CoteDIvoire("Cote d'Ivoire", 225, 8, 8, "", 602),
        Egypt("Egpyt", 20, 9, 10, "0", 625),
        Finland("Finland", 358, 6, 11, "0", 224),
        France("France", 33, 9, 9, "0", 208),
        Gambia("Gambia", 220, 7, 7, "0", 607),
        Germany("Germany", 49, 7, 12, "0", 262),
        Ghana("Ghana", 233, 9, 9, "0", 620),
        Greece("Greece", 30, 10, 10, "0", 202),
        GuineaBissau("Guinea Bissau", 245, 7, 7, "0", 632),
        Guinea("Guinea", 224, 8, 9, "0", 611),
        India("India", 91, 10, 10, "0", 404, 405),
        Italy("Italy", 39, 9, 10, "0", 222),
        Japan("Japan", 81, 10, 10, "0", 440, 441),
        Kenya("Kenya", 254, 9, 9, "0", 639),
        Liberia("Liberia", 231, 7, 9, "0", 618),
        Libya("Libya", 218, 9, 9, "0", 606),
        Malawi("Malawi", 265, 9, 9, "0", 650),
        Malaysia("Malaysia", 60, 9, 10, "0", 502),
        Mali("Mali", 223, 8, 8, "0", 610),
        Mauritania("Mauritania", 222, 8, 8, "0", 609),
        Morocco("Morocco", 212, 9, 9, "0", 604),
        Niger("Niger", 227, 8, 8, "0", 614),
        Nigeria("Nigeria", 234, 10, 10, "0", 621),
        NorthKorea("North Korea", 850, 10, 10, "0", 467),
        Russia("Russia", 7, 10, 10, "8", 250),
        SaudiArabia("Saudi Arabia", 966, 9, 9, "0", 420),
        Senegal("Senegal", 221, 9, 9, "0", 608),
        SierraLeone("Sierra Leone", 232, 8, 8, "0", 619),
        SouthAfrica("South Africa", 27, 9, 9, "0", 655),
        SouthKorea("South Korea", 82, 9, 10, "0", 450),
        Spain("Spain", 34, 9, 9, "0", 214),
        Sweden("Sweden", 46, 9, 9, "0", 240),
        Switzerland("Switzerland", 41, 9, 9, "0", 228),
        Togo("Togo", 228, 8, 8, "0", 615),
        Ukraine("Ukraine", 380, 9, 9, "0", 225),
        UnitedArabEmirate("United Arab Emirate", 971, 10, 10, "0", 424, 430, 431),
        UnitedKingdom("United Kingdom", 44, 10, 10, "0,1", 234, 235),
        UnitedStates("United States", 1, 10, 10, "0,1", 301);

        private final int countryCode;
        private final String countryName;
        private final int allowableFromLength;
        private final int allowableToLength;
        private final String startDigitToIgnore;
        private final List<Integer> mcc;
        private String preceeding = "";

        public String getCountryName() {
            return this.countryName;
        }

        public int getCountryCode() {
            return this.countryCode;
        }

        public int getAllowableFromLength() {
            return this.allowableFromLength;
        }

        public int getAllowableToLength() {
            return this.allowableToLength;
        }

        public String getStartDigitToIgnore() {
            return this.startDigitToIgnore;
        }

        public List<Integer> getMcc() {
            return this.mcc;
        }

        private boolean isDigit(String phoneNumber) {
            return phoneNumber.matches("[0-9]+");
        }

        private boolean startWithPlus(String phoneNumber) {
            return phoneNumber.matches("[+][0-9]+");
        }

        private boolean startWithCountryCode(String countryCode, String phoneNumber) {
            String buildreg = "";
            for (char a : countryCode.toCharArray()) {
                buildreg = buildreg + "[" + a + "]";
            }
            return phoneNumber.matches(buildreg + "[0-9]+");
        }

        private boolean startWithPlusAndCountryCode(String countryCode, String phoneNumber) {
            String buildreg = "";
            for (char a : countryCode.toCharArray()) {
                buildreg = buildreg + "[" + a + "]";
            }
            return phoneNumber.matches("[+]" + buildreg + "[0-9]+");
        }

        private boolean meetCountryPhoneNumberRequirement(Country countries, String phoneNumber) {
            return phoneNumber.length() >= countries.getAllowableFromLength() && phoneNumber.length() <= countries.getAllowableToLength();
        }

        private PhoneModel isNumberValid(Country countries, String phoneNumber) throws PhoneFormatException {
            PhoneModel model = new PhoneModel();
            phoneNumber = phoneNumber.trim();
            if (this.startWithPlusAndCountryCode(String.valueOf(countries.getCountryCode()), phoneNumber)) {
                String cc = String.valueOf(countries.getCountryCode());
                int length = cc.length();
                if (this.startWithPlus(phoneNumber)) {
                    ++length;
                }
                if (this.meetCountryPhoneNumberRequirement(countries, phoneNumber = this.formatNumber(countries, phoneNumber.substring(length)))) {
                    phoneNumber = "+" + cc + phoneNumber;
                    model.setIsValidPhoneNumber(true);
                }
            } else if (this.isDigit(phoneNumber)) {
                if (this.startWithCountryCode(String.valueOf(countries.getCountryCode()), phoneNumber)) {
                    String cc = String.valueOf(countries.getCountryCode());
                    if (this.meetCountryPhoneNumberRequirement(countries, phoneNumber = this.formatNumber(countries, phoneNumber.substring(cc.length())))) {
                        phoneNumber = cc + phoneNumber;
                        model.setIsValidPhoneNumber(true);
                    }
                } else {
                    this.preceeding = "";
                    if (this.meetCountryPhoneNumberRequirement(countries, phoneNumber = this.formatNumber(countries, phoneNumber))) {
                        phoneNumber = this.preceeding + phoneNumber;
                        model.setIsValidPhoneNumber(true);
                    }
                }
            } else {
                System.out.println(phoneNumber);
                if (this.startWithPlus(phoneNumber)) {
                    throw new PhoneFormatException("does not match " + (Object)((Object)countries) + " countrycode");
                }
                throw new PhoneFormatException("Contains non digit characters");
            }
            if (model.isValidPhoneNumber()) {
                model.setPhoneNumber(phoneNumber);
            }
            return model;
        }

        public PhoneModel isNumberValid(String phoneNumber) throws PhoneFormatException {
            return this.isNumberValid(this, phoneNumber);
        }

        public String toCountryCode(String phoneNumber) throws PhoneFormatException {
            PhoneModel model = null;
            phoneNumber = phoneNumber.trim();
            if (this.startWithPlus(phoneNumber = phoneNumber.trim())) {
                if (this.startWithPlusAndCountryCode(String.valueOf(this.getCountryCode()), phoneNumber)) {
                    model = this.isNumberValid(this, phoneNumber);
                }
            } else if (this.startWithCountryCode(String.valueOf(this.getCountryCode()), phoneNumber)) {
                model = this.isNumberValid(this, phoneNumber);
            } else {
                phoneNumber = "+" + String.valueOf(this.getCountryCode()) + phoneNumber;
                model = this.isNumberValid(this, phoneNumber);
            }
            if (model != null && model.isValidPhoneNumber()) {
                return model.getPhoneNumber();
            }
            return "";
        }

        public String toPlainNumber(String phoneNumber) throws PhoneFormatException {
            PhoneModel model = null;
            phoneNumber = phoneNumber.trim();
            if (this.startWithPlusAndCountryCode(String.valueOf(this.getCountryCode()), phoneNumber)) {
                String cc = String.valueOf(this.getCountryCode());
                phoneNumber = phoneNumber.substring(cc.length() + 1);
                model = this.isNumberValid(this, phoneNumber);
            } else if (this.startWithCountryCode(String.valueOf(this.getCountryCode()), phoneNumber)) {
                String cc = String.valueOf(this.getCountryCode());
                phoneNumber = phoneNumber.substring(cc.length());
                model = this.isNumberValid(this, phoneNumber);
            } else {
                phoneNumber = this.formatNumber(this, phoneNumber);
                phoneNumber = this.preceeding + phoneNumber;
                model = this.isNumberValid(this, phoneNumber);
            }
            if (model != null && model.isValidPhoneNumber()) {
                return model.getPhoneNumber();
            }
            return "";
        }

        private String formatNumber(Country countries, String phoneNumber) {
            ArrayList<String> preceedingDigit = new ArrayList<String>(Arrays.asList(countries.getStartDigitToIgnore().split(",")));
            while (!phoneNumber.trim().isEmpty()) {
                if (preceedingDigit.contains(phoneNumber.substring(0, 1))) {
                    this.preceeding = phoneNumber.substring(0, 1);
                    phoneNumber = phoneNumber.substring(1);
                    continue;
                }
                return phoneNumber;
            }
            return phoneNumber;
        }

        private Country(String countryName, int countryCode, int allowableFromLength, int allowableToLength, String startDigitToIgnore, Integer ... mcc) {
            this.countryCode = countryCode;
            this.countryName = countryName;
            this.allowableFromLength = allowableFromLength;
            this.allowableToLength = allowableToLength;
            this.startDigitToIgnore = startDigitToIgnore;
            this.mcc = new ArrayList<Integer>();
            this.mcc.addAll(Arrays.asList(mcc));
        }
    }
}

