/*
 * Decompiled with CFR 0.152.
 */
package xyz.belvi.baseauth.countrySelector;

import android.content.Context;
import android.graphics.Typeface;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.belvi.validator.PhoneNumberValidator;
import xyz.belvi.baseauth.R;
import xyz.belvi.baseauth.countrySelector.CountrySelectorHolder;

public abstract class CountrySelectorAdapter
extends RecyclerView.Adapter<CountrySelectorHolder> {
    private PhoneNumberValidator.Country selectedCountries;

    public CountrySelectorAdapter(PhoneNumberValidator.Country countries) {
        this.selectedCountries = countries;
    }

    public CountrySelectorHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new CountrySelectorHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.cc_selector_item, parent, false));
    }

    public void onBindViewHolder(CountrySelectorHolder holder, final int position) {
        holder.getCountryName().setText((CharSequence)PhoneNumberValidator.Country.values()[position].getCountryName());
        holder.getCountryCode().setText((CharSequence)("( +" + String.valueOf(PhoneNumberValidator.Country.values()[position].getCountryCode()) + " )"));
        if (this.selectedCountries == PhoneNumberValidator.Country.values()[position]) {
            holder.getCountryName().setTypeface(null, 1);
            holder.getCountryCode().setTypeface(null, 1);
        } else {
            holder.getCountryName().setTypeface(Typeface.DEFAULT);
            holder.getCountryCode().setTypeface(Typeface.DEFAULT);
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CountrySelectorAdapter.this.onCountrySelected(PhoneNumberValidator.Country.values()[position]);
            }
        });
    }

    public int getItemCount() {
        return PhoneNumberValidator.Country.values().length;
    }

    public abstract void onCountrySelected(PhoneNumberValidator.Country var1);
}

