/*
 * Decompiled with CFR 0.152.
 */
package xyz.belvi.baseauth.countrySelector;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import com.belvi.validator.PhoneNumberValidator;
import java.util.Arrays;
import xyz.belvi.baseauth.R;
import xyz.belvi.baseauth.countrySelector.CountrySelectorAdapter;

public class CountrySelectorActivity
extends AppCompatActivity {
    public static final String SELECTED_COUNTRY = "SELECTED_COUNTRY";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_country_selector);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.initSelector();
    }

    private void initSelector() {
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.cc_list);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
        recyclerView.setHasFixedSize(false);
        PhoneNumberValidator.Country countries = null;
        try {
            countries = PhoneNumberValidator.Country.valueOf((String)this.getIntent().getStringExtra(SELECTED_COUNTRY));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (countries != null) {
            recyclerView.scrollToPosition(Arrays.asList(PhoneNumberValidator.Country.values()).indexOf(countries));
        }
        recyclerView.setAdapter((RecyclerView.Adapter)new CountrySelectorAdapter(countries){

            @Override
            public void onCountrySelected(PhoneNumberValidator.Country countries) {
                CountrySelectorActivity.this.setResult(-1, CountrySelectorActivity.this.getIntent().putExtra(CountrySelectorActivity.SELECTED_COUNTRY, countries.name()));
                CountrySelectorActivity.this.finish();
            }
        });
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        this.onBackPressed();
        return super.onOptionsItemSelected(item);
    }
}

