/*
 * Decompiled with CFR 0.152.
 */
package xyz.belvi.baseauth.auth.base;

import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatTextView;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.belvi.validator.PhoneFormatException;
import com.belvi.validator.PhoneNumberValidator;
import xyz.belvi.baseauth.R;
import xyz.belvi.baseauth.auth.base.AuthActivity;
import xyz.belvi.baseauth.callbacks.AuthListeners;
import xyz.belvi.baseauth.custom.URLSpanNoUnderline;

public class AuthVerifyFragment
extends Fragment
implements AuthListeners.AuthResults {
    private final String PHONE_KEY = "PHONE_KEY";
    private final String COUNTRY_KEY = "COUNTRY_KEY";
    private final String CODE_SIZE = "CODE_SIZE";
    private String CALL_URL = "Call";
    private String PHONE_URL = "Phone";
    int secCounter;
    Runnable runnable;
    Handler handler = new Handler();
    private AppCompatTextView waitField;
    private AppCompatTextView statusField;
    private View rootView;

    public AuthVerifyFragment startFragment(String phone, String country, int codeSize) {
        Bundle bundle = new Bundle();
        bundle.putString("PHONE_KEY", phone);
        bundle.putString("COUNTRY_KEY", country);
        bundle.putInt("CODE_SIZE", codeSize);
        this.setArguments(bundle);
        return this;
    }

    private AuthActivity getAuthActivity() {
        return (AuthActivity)this.getActivity();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getAuthActivity().bindAuthResult(this);
        this.rootView = inflater.inflate(R.layout.auth_verify_fragment, container, false);
        this.waitField = (AppCompatTextView)this.rootView.findViewById(R.id.wait_field);
        this.statusField = (AppCompatTextView)this.rootView.findViewById(R.id.incorrect_code);
        this.waitField.setLinksClickable(true);
        this.waitField.setMovementMethod(LinkMovementMethod.getInstance());
        this.addCodeFields(this.getArguments().getInt("CODE_SIZE"));
        PhoneNumberValidator.Country country = PhoneNumberValidator.Country.valueOf((String)this.getArguments().getString("COUNTRY_KEY"));
        String phone = this.getArguments().getString("PHONE_KEY");
        try {
            ((AppCompatTextView)this.rootView.findViewById(R.id.phone_instruction)).setText((CharSequence)String.format(this.getString(R.string.type_in), country.toCountryCode(phone)));
            this.getAuthActivity().authPhone(country, phone, false, false);
        }
        catch (PhoneFormatException e) {
            e.printStackTrace();
        }
        return this.rootView;
    }

    private void addCodeFields(int codeSize) {
        LinearLayout codeFieldLayout = (LinearLayout)this.rootView.findViewById(R.id.code_layout_grp);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        for (int x = 0; x < codeSize; ++x) {
            codeFieldLayout.addView(inflater.inflate(R.layout.code_field, (ViewGroup)codeFieldLayout, false));
        }
        this.addEvents((ViewGroup)codeFieldLayout);
    }

    private void addEvents(final ViewGroup viewGroup) {
        int x = 0;
        while (x < viewGroup.getChildCount()) {
            final AppCompatEditText child = (AppCompatEditText)viewGroup.getChildAt(x);
            if (x == 0) {
                child.requestFocus();
                this.showKeyboard();
            }
            child.setTag((Object)x);
            final int finalX = x++;
            child.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View view, int keyCode, KeyEvent keyEvent) {
                    if (keyEvent.getAction() == 0 && keyCode == 67) {
                        AuthVerifyFragment.this.predictNext(child, ' ', finalX, viewGroup, true);
                    } else if (keyEvent.getAction() == 0 && Character.isDigit((char)keyEvent.getUnicodeChar())) {
                        AuthVerifyFragment.this.predictNext(child, (char)keyEvent.getUnicodeChar(), finalX, viewGroup, false);
                    }
                    return false;
                }
            });
            child.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    AuthVerifyFragment.this.showKeyboard();
                    return true;
                }
            });
            child.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View view, boolean b) {
                    if (b) {
                        AuthVerifyFragment.this.requestRightChild(viewGroup);
                    }
                }
            });
        }
    }

    private boolean requestRightChild(ViewGroup viewGroup) {
        for (int index = 0; index < viewGroup.getChildCount(); ++index) {
            AppCompatEditText child = (AppCompatEditText)viewGroup.getChildAt(index);
            if (!child.getText().toString().isEmpty()) continue;
            child.requestFocus();
            return true;
        }
        AppCompatEditText child = (AppCompatEditText)viewGroup.getChildAt(viewGroup.getChildCount() - 1);
        child.requestFocus();
        return true;
    }

    private boolean predictNext(AppCompatEditText editText, char c, int index, ViewGroup viewGroup, boolean isDelete) {
        if (isDelete) {
            this.statusField.setVisibility(8);
            if (index + 1 == viewGroup.getChildCount() && !editText.getText().toString().trim().isEmpty()) {
                editText.setText((CharSequence)"");
            } else if (index != 0) {
                AppCompatEditText child = (AppCompatEditText)viewGroup.getChildAt(index - 1);
                child.setText((CharSequence)"");
                child.requestFocus();
            }
        } else if (editText.getText().toString().trim().isEmpty()) {
            editText.setText((CharSequence)String.valueOf(c).trim());
            if (index + 1 < viewGroup.getChildCount()) {
                AppCompatEditText child = (AppCompatEditText)viewGroup.getChildAt(index + 1);
                child.requestFocus();
            } else {
                this.manualAuth();
            }
        }
        return false;
    }

    private String getCode(ViewGroup viewGroup) {
        String code = "";
        for (int x = 0; x < viewGroup.getChildCount(); ++x) {
            AppCompatEditText child = (AppCompatEditText)viewGroup.getChildAt(x);
            code = code + child.getText().toString().trim();
        }
        return code;
    }

    private void manualAuth() {
        LinearLayout viewGroup = (LinearLayout)this.rootView.findViewById(R.id.code_layout_grp);
        if (this.getCode((ViewGroup)viewGroup).length() == this.getArguments().getInt("CODE_SIZE")) {
            this.getAuthActivity().manualAuth(this.getCode((ViewGroup)viewGroup));
        }
    }

    @Override
    public void codeSent() {
        this.manualAuth();
        this.secCounter = 60;
        this.runnable = new Runnable(){

            @Override
            public void run() {
                --AuthVerifyFragment.this.secCounter;
                if (AuthVerifyFragment.this.secCounter != 0) {
                    String dec = "Please wait <a href=''>" + (AuthVerifyFragment.this.secCounter < 10 ? "0" + AuthVerifyFragment.this.secCounter : Integer.valueOf(AuthVerifyFragment.this.secCounter)) + " secs</a>";
                    AuthVerifyFragment.this.handler.postDelayed((Runnable)this, 1000L);
                    Spanned sequence = Html.fromHtml((String)dec);
                    AuthVerifyFragment.this.waitField.setText((CharSequence)sequence);
                    AuthVerifyFragment.this.stripUnderlines((TextView)AuthVerifyFragment.this.waitField, false);
                } else {
                    AuthVerifyFragment.this.initResend();
                }
            }
        };
        this.handler.postDelayed(this.runnable, 1000L);
    }

    @Override
    public void timeOut() {
        this.handler.removeCallbacks(this.runnable);
        this.initResend();
    }

    @Override
    public void verificationFailure(Exception e) {
        this.statusField.setText((CharSequence)e.getMessage());
        this.statusField.setVisibility(0);
    }

    private void initResend() {
        String dec = "";
        dec = this.getAuthActivity().getAuthMode().isCallSupported() ? "<a href='" + this.PHONE_URL + "'><b>Resend Code<b></a> &nbsp;&nbsp;\u2e33&nbsp;&nbsp; <a href='" + this.CALL_URL + "'><b>Call Me<b> </a>" : "<a href='" + this.PHONE_URL + "'><b>Resend Code<b></a>";
        Spanned sequence = Html.fromHtml((String)dec);
        this.waitField.setText((CharSequence)sequence);
        this.stripUnderlines((TextView)this.waitField, true);
    }

    private void stripUnderlines(TextView textView, final boolean shouldClick) {
        URLSpan[] spans;
        SpannableString s = new SpannableString(textView.getText());
        for (URLSpan span : spans = (URLSpan[])s.getSpans(0, s.length(), URLSpan.class)) {
            int start = s.getSpanStart((Object)span);
            int end = s.getSpanEnd((Object)span);
            s.removeSpan((Object)span);
            span = new URLSpanNoUnderline(span.getURL(), new URLSpanNoUnderline.OnClickListener(){

                @Override
                public void onClick(String url) {
                    if (shouldClick) {
                        AuthVerifyFragment.this.waitField.setText((CharSequence)"Please wait.");
                        AuthVerifyFragment.this.statusField.setVisibility(8);
                        if (url.equalsIgnoreCase(AuthVerifyFragment.this.CALL_URL)) {
                            AuthVerifyFragment.this.getAuthActivity().authPhone(PhoneNumberValidator.Country.valueOf((String)AuthVerifyFragment.this.getArguments().getString("COUNTRY_KEY")), AuthVerifyFragment.this.getArguments().getString("PHONE_KEY"), true, true);
                        } else {
                            AuthVerifyFragment.this.getAuthActivity().authPhone(PhoneNumberValidator.Country.valueOf((String)AuthVerifyFragment.this.getArguments().getString("COUNTRY_KEY")), AuthVerifyFragment.this.getArguments().getString("PHONE_KEY"), true, false);
                        }
                    }
                }
            });
            s.setSpan((Object)span, start, end, 0);
        }
        textView.setText((CharSequence)s);
    }

    private void showKeyboard() {
        View view = this.getActivity().getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput(view, 0);
        }
    }
}

