/*
 * Decompiled with CFR 0.152.
 */
package xyz.belvi.baseauth.auth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatEditText;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.belvi.validator.PhoneFormatException;
import com.belvi.validator.PhoneModel;
import com.belvi.validator.PhoneNumberValidator;
import xyz.belvi.baseauth.R;
import xyz.belvi.baseauth.auth.base.AuthVerifyFragment;
import xyz.belvi.baseauth.countrySelector.CountrySelectorActivity;

public class AuthDetailsFragment
extends Fragment {
    private int R_C = 500;
    private AppCompatEditText phoneCompatEditText;
    private AppCompatButton verifyBtn;
    private View rootView;
    PhoneNumberValidator.Country selectedCountry;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.auth_fragment, container, false);
        this.selectedCountry = new PhoneNumberValidator().getUserCountry(this.getContext());
        final AppCompatEditText ccCompatEditText = (AppCompatEditText)this.rootView.findViewById(R.id.country_code_selector);
        this.phoneCompatEditText = (AppCompatEditText)this.rootView.findViewById(R.id.phone_number);
        this.phoneCompatEditText.setText((CharSequence)this.getLineNumber());
        this.verifyBtn = (AppCompatButton)this.rootView.findViewById(R.id.verify_btn);
        this.phoneCompatEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                AuthDetailsFragment.this.verifyInput();
            }

            public void afterTextChanged(Editable editable) {
            }
        });
        ccCompatEditText.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                ccCompatEditText.requestFocus();
                return false;
            }
        });
        ccCompatEditText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AuthDetailsFragment.this.startActivityForResult(new Intent(view.getContext(), CountrySelectorActivity.class).putExtra("SELECTED_COUNTRY", AuthDetailsFragment.this.selectedCountry == null ? null : AuthDetailsFragment.this.selectedCountry.name()), AuthDetailsFragment.this.R_C);
            }
        });
        this.verifyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AuthDetailsFragment.this.getFragmentManager().beginTransaction().addToBackStack(null).add(R.id.auth_content_frame, (Fragment)new AuthVerifyFragment().startFragment(AuthDetailsFragment.this.phoneCompatEditText.getText().toString(), AuthDetailsFragment.this.selectedCountry.name(), AuthDetailsFragment.this.getActivity().getIntent().getIntExtra(" xyz.belvi.baseauth.auth.base.CODE_LENGTH", 0))).commitAllowingStateLoss();
            }
        });
        this.setCountryCodeText();
        return this.rootView;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.R_C && resultCode == -1) {
            this.selectedCountry = PhoneNumberValidator.Country.valueOf((String)data.getStringExtra("SELECTED_COUNTRY"));
            this.setCountryCodeText();
        }
    }

    private void setCountryCodeText() {
        if (this.selectedCountry != null) {
            ((TextView)this.rootView.findViewById(R.id.country_code_selector)).setText((CharSequence)(this.selectedCountry.getCountryName() + " ( +" + this.selectedCountry.getCountryCode() + " )"));
            this.verifyInput();
        }
    }

    private String getLineNumber() {
        TelephonyManager tMgr = (TelephonyManager)this.getActivity().getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.READ_SMS") == 0 && ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.READ_PHONE_STATE") == 0) {
            String mPhoneNumber = tMgr.getLine1Number();
            return mPhoneNumber;
        }
        return "";
    }

    private void verifyInput() {
        if (this.selectedCountry != null) {
            String phoneNumber = this.phoneCompatEditText.getText().toString();
            try {
                PhoneModel phoneModel = this.selectedCountry.isNumberValid(phoneNumber);
                this.verifyBtn.setEnabled(phoneModel.isValidPhoneNumber());
            }
            catch (PhoneFormatException e) {
                e.printStackTrace();
            }
        }
    }
}

