/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.TypeConverter;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.XmlRpcNotAuthorizedException;
import org.apache.xmlrpc.metadata.Util;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;

public class ReflectiveXmlRpcHandler
implements XmlRpcHandler {
    private final AbstractReflectiveHandlerMapping mapping;
    private final Class clazz;
    private final MethodData[] methods;
    private final Object theInstance;

    public ReflectiveXmlRpcHandler(AbstractReflectiveHandlerMapping pMapping, TypeConverterFactory pTypeConverterFactory, Class pClass, boolean pInstanceIsStateless, Method[] pMethods) throws XmlRpcException {
        this.mapping = pMapping;
        this.clazz = pClass;
        this.methods = new MethodData[pMethods.length];
        for (int i = 0; i < this.methods.length; ++i) {
            this.methods[i] = new MethodData(pMethods[i], pTypeConverterFactory);
        }
        this.theInstance = pInstanceIsStateless ? this.newInstance() : null;
    }

    private Object getInstance(XmlRpcRequest pRequest) throws XmlRpcException {
        AbstractReflectiveHandlerMapping.InitializationHandler ih = this.mapping.getInitializationHandler();
        if (ih == null) {
            return this.theInstance == null ? this.newInstance() : this.theInstance;
        }
        Object instance = this.newInstance();
        ih.init(pRequest, instance);
        return instance;
    }

    public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
        AbstractReflectiveHandlerMapping.AuthenticationHandler authHandler = this.mapping.getAuthenticationHandler();
        if (authHandler != null && !authHandler.isAuthorized(pRequest)) {
            throw new XmlRpcNotAuthorizedException("Not authorized");
        }
        Object[] args = new Object[pRequest.getParameterCount()];
        for (int j = 0; j < args.length; ++j) {
            args[j] = pRequest.getParameter(j);
        }
        Object instance = this.getInstance(pRequest);
        for (int i = 0; i < this.methods.length; ++i) {
            int j;
            MethodData methodData = this.methods[i];
            TypeConverter[] converters = methodData.typeConverters;
            if (args.length != converters.length) continue;
            boolean matching = true;
            for (j = 0; j < args.length; ++j) {
                if (converters[j].isConvertable(args[i])) continue;
                matching = false;
                break;
            }
            if (!matching) continue;
            for (j = 0; j < args.length; ++j) {
                args[i] = converters[i].convert(args[i]);
            }
            return this.invoke(instance, methodData.method, args);
        }
        throw new XmlRpcException("No method matching arguments: " + Util.getSignature(args));
    }

    private Object invoke(Object pInstance, Method pMethod, Object[] pArgs) throws XmlRpcException {
        try {
            return pMethod.invoke(pInstance, pArgs);
        }
        catch (IllegalAccessException e) {
            throw new XmlRpcException("Illegal access to method " + pMethod.getName() + " in class " + this.clazz.getName(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new XmlRpcException("Illegal argument for method " + pMethod.getName() + " in class " + this.clazz.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new XmlRpcException("Failed to invoke method " + pMethod.getName() + " in class " + this.clazz.getName() + ": " + t.getMessage(), t);
        }
    }

    protected Object newInstance() throws XmlRpcException {
        try {
            return this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new XmlRpcException("Failed to instantiate class " + this.clazz.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new XmlRpcException("Illegal access when instantiating class " + this.clazz.getName(), (Throwable)e);
        }
    }

    private static class MethodData {
        final Method method;
        final TypeConverter[] typeConverters;

        MethodData(Method pMethod, TypeConverterFactory pTypeConverterFactory) {
            this.method = pMethod;
            Class<?>[] paramClasses = this.method.getParameterTypes();
            this.typeConverters = new TypeConverter[paramClasses.length];
            for (int i = 0; i < paramClasses.length; ++i) {
                this.typeConverters[i] = pTypeConverterFactory.getTypeConverter(paramClasses[i]);
            }
        }
    }
}

